<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\facebook_login;

use app\controllers\AjaxController;
use app\models\Form;
use app\modules\addons\EventManagerInterface;
use app\modules\addons\FormManagerInterface;
use app\modules\addons\modules\facebook_login\models\FacebookApp;
use app\modules\addons\modules\facebook_login\models\FacebookAppItem;

class Module extends \yii\base\Module implements EventManagerInterface, FormManagerInterface
{
    public $id = "facebook_login";
    public $defaultRoute = 'admin/index';
    public $controllerLayout = '@app/views/layouts/main';

    /**
     * @inheritdoc
     */
    public function getDefaultModelClasses()
    {
        return [
            'FacebookApp' => FacebookApp::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function attachGlobalEvents()
    {
        return [
            AjaxController::EVENT_FORM_COPIED => function ($event) {
                $this->onFormCopied($event);
            },
        ];
    }

    /**
     * @inheritdoc
     */
    public function attachClassEvents()
    {
        return [
            'yii\base\View' => [
                'afterRender' => [
                    ['app\modules\addons\modules\facebook_login\Module', 'addFacebookButton']
                ],
            ],
            'app\models\Form' => [
                'beforeDelete' => [
                    ['app\modules\addons\modules\facebook_login\Module', 'onFormDeleted']
                ]
            ],
        ];
    }

    /**
     * Event Handler
     * When a Form is Copied
     *
     * @param $event
     */
    public function onFormCopied($event)
    {
        if (isset($event, $event->form, $event->form->id, $event->oldForm, $event->oldForm->id)) {
            $oModels = FacebookApp::findAll(['form_id' => $event->oldForm->id]);
            foreach ($oModels as $oModel) {
                $model = new FacebookApp();
                $model->attributes = $oModel->attributes;
                $model->id = null;
                $model->form_id = $event->form->id;
                $model->isNewRecord = true;
                $model->save();

                foreach ($oModel->items as $oItem) {
                    $item = new FacebookAppItem();
                    $item->attributes = $oItem->attributes;
                    $item->id = null;
                    $item->form_id = $event->form->id;
                    $item->isNewRecord = true;
                    $item->save();
                }
            }
        }
    }

    /**
     * Event Handler
     * Before a form model is deleted
     *
     * @param $event
     */
    public static function onFormDeleted($event)
    {
        if (isset($event) && isset($event->sender) && $event->sender instanceof Form && isset($event->sender->id)) {
            FacebookApp::deleteAll(['form_id' => $event->sender->id]);
        }
    }

    /**
     * Event Handler
     * After a view is rendered
     *
     * @param $event
     */
    public static function addFacebookButton($event)
    {

        if (isset($event, $event->sender, $event->sender->context) &&
            isset($event->sender->context->module, $event->sender->context->module->requestedRoute) &&
            $event->sender->context->module->requestedRoute === "app/embed" ) {

            $formModel = $event->sender->context->getFormModel();
            $facebook = FacebookApp::findOne(['form_id' => $formModel->id, 'status' => 1]);

            if ($facebook) {

                $itemFields = [];
                $itemCode = '';
                foreach ($facebook->items as $item) {
                    if (isset($item->field_id, $item->facebook_data)) {
                        // Set fields
                        $itemFields[] = $item->facebook_data;
                        // Set facebook data as field value
                        $itemCode .= <<<ITEM_CODE
$('#{$item->field_id}').val(response.{$item->facebook_data});
ITEM_CODE;
                    }
                }
                $itemFields = implode(',', $itemFields);

                $onDebug = defined('YII_DEBUG') && YII_DEBUG ? 1 : 0;

                $jqCode = <<<JQ_CODE
$(document).ready(function() {
    var app_id = '{$facebook->app_id}';
    var app_scope = '{$facebook->app_scope}';
    var login_button = '{$facebook->login_button}';
    var logout_button = '{$facebook->logout_button}';

    window.fbAsyncInit = function() {
        FB.init({
            appId      : app_id,
            status     : true,
            cookie     : true,
            xfbml      : true,
            version    : '{$facebook->app_version}'
        });
        FB.getLoginStatus(function(response) {
            statusChangeCallback(response, function() {});
        });
    };
    var statusChangeCallback = function(response, callback) {
        if (response.status === 'connected') {
            getFacebookData();
        } else {
            callback(false);
        }
    }
    var checkLoginState = function(callback) {
        FB.getLoginStatus(function(response) {
            callback(response);
        });
    }
    var getFacebookData =  function() {
        FB.api('/me', {fields: '{$itemFields}'}, function(response) {
            if ({$onDebug}) {
                console.log(response);        
            } 
            $('#facebook-login').after(logout_button);
            $('#facebook-login').remove();
            {$itemCode}            
        });
    }
    var facebookLogin = function() {
        checkLoginState(function(data) {
            if (data.status !== 'connected') {
                FB.login(function(response) {
                    if (response.status === 'connected') {
                        getFacebookData();
                    }
                }, {scope: app_scope});
            }
        })
    }
    var facebookLogout = function() {
        checkLoginState(function(data) {
            if (data.status === 'connected') {
                FB.logout(function(response) {
                    $('#facebook-logout').before(login_button);
                    $('#facebook-logout').remove();
                })
            }
        })

    }
    
    // Event Handlers
    $(document).on('click', '#facebook-login', function(e) {
        e.preventDefault();
        facebookLogin();
    })
    $(document).on('click', '#facebook-logout', function(e) {
        e.preventDefault();
        if (confirm("Are you sure you want to close this session?")) {
            facebookLogout();
        } else {
            return false;        
        }
    })
});
JQ_CODE;

                $flCode = <<<FB_CODE

<!-- Facebook Login -->
<script>
(function(d, s, id) {
    var js, fjs = d.getElementsByTagName(s)[0];
    if (d.getElementById(id)) return;
    js = d.createElement(s); js.id = id;
    js.src = "//connect.facebook.net/en_US/sdk.js";
    fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));

{$jqCode}
</script>
<!-- End Facebook Login -->
</body>
FB_CODE;

                $content = $event->output;
                $content =  str_replace(["<!--facebook_login-->", "&lt;!--facebook_login--&gt;​"], $facebook->login_button, $content);
                $event->output =  str_replace("</body>", $flCode, $content);
            }
        }
    }
}
