<?php

use app\components\widgets\ConditionsBuilder;
use app\helpers\Country;
use kartik\depdrop\DepDrop;
use kartik\form\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\eu_vat\models\EuVat */
/* @var $itemModel app\modules\addons\modules\eu_vat\models\EuVatItem */
/* @var $form yii\widgets\ActiveForm */
/* @var $forms array [id => name] of Form models */

$fieldsUrl = Url::to(['/addons/eu_vat/admin/fields']);

?>

<div class="eu_vat-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row" style="margin-top: 20px;">
        <div class="col-sm-12">
            <?= $form->field($model, 'name')->textInput([
                'placeholder' => Yii::t('app', "Enter a configuration name..."),
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'form_id')->widget(Select2::class, [
                'data' => $forms,
                'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(Yii::t('app', 'Form')); ?>
        </div>
        <div class="col-sm-6">
            <?php if ($model->isNewRecord) { $model->status = 1;} ?>
            <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= ConditionsBuilder::widget([
                'label' => Yii::t('app', 'Conditions'),
            ]) ?>
            <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'business_country_code')->widget(Select2::class, [
                'data' => Country::countriesInEU(),
                'options' => [
                    'placeholder' => Yii::t('app', 'Select...'),
                ],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]); ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'ip_based_country')->widget(SwitchInput::class) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <legend><?= Yii::t('app', 'Field Mapping') ?></legend>
        </div>
    </div>

    <?php if ($model->isNewRecord || count($model->items) === 0): ?>

        <fieldset class="item">
            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($itemModel, '[0]country_code')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, '[0]vat_tax_rate')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, '[0]vat_number')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 25px;">
                        <button type="button" class="btn btn-icon btn-default btn-add">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, '[0]vat_subtotal')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, '[0]vat_taxes')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, '[0]vat_total')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                        ]
                    ]) ?>
                </div>
            </div>
        </fieldset>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($itemModel, 'country_code')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, 'vat_tax_rate')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, 'vat_number')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-icon btn-default btn-remove">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, 'vat_subtotal')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, 'vat_taxes')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, 'vat_total')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
            </div>
        </fieldset>

    <?php else: ?>

        <?php foreach($model->items as $i => $item): ?>
            <fieldset class="item">
                <div class="row">
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('item-'.$i.'-country_code',
                            $item->country_code, ['id'=>'item-'.$i.'-country_code']) ?>
                        <?= $form->field($itemModel, '['.$i.']country_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['euvat-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $fieldsUrl,
                                'params'=>['item-'.$i.'-country_code'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('item-'.$i.'-vat_tax_rate',
                            $item->vat_tax_rate, ['id'=>'item-'.$i.'-vat_tax_rate']) ?>
                        <?= $form->field($itemModel, '['.$i.']vat_tax_rate')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['euvat-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $fieldsUrl,
                                'params'=>['item-'.$i.'-vat_tax_rate'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= Html::hiddenInput('item-'.$i.'-vat_number',
                            $item->vat_number, ['id'=>'item-'.$i.'-vat_number']) ?>
                        <?= $form->field($itemModel, '['.$i.']vat_number')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['euvat-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $fieldsUrl,
                                'params'=>['item-'.$i.'-vat_number'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('item-'.$i.'-vat_subtotal',
                            $item->vat_subtotal, ['id'=>'item-'.$i.'-vat_subtotal']) ?>
                        <?= $form->field($itemModel, '['.$i.']vat_subtotal')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['euvat-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $fieldsUrl,
                                'params'=>['item-'.$i.'-vat_subtotal'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('item-'.$i.'-vat_taxes',
                            $item->vat_taxes, ['id'=>'item-'.$i.'-vat_taxes']) ?>
                        <?= $form->field($itemModel, '['.$i.']vat_taxes')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['euvat-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $fieldsUrl,
                                'params'=>['item-'.$i.'-vat_taxes'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= Html::hiddenInput('item-'.$i.'-vat_total',
                            $item->vat_total, ['id'=>'item-'.$i.'-vat_total']) ?>
                        <?= $form->field($itemModel, '['.$i.']vat_total')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['euvat-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $fieldsUrl,
                                'params'=>['item-'.$i.'-vat_total'],
                            ]
                        ]) ?>
                    </div>
                </div>
            </fieldset>
        <?php endforeach; ?>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-3">
                    <?= Html::hiddenInput('item-country_code', '', ['id'=>'item-country_code']) ?>
                    <?= $form->field($itemModel, 'country_code')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                            'params'=>['item-country_code'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= Html::hiddenInput('item-vat_tax_rate', '', ['id'=>'item-vat_tax_rate']) ?>
                    <?= $form->field($itemModel, 'vat_tax_rate')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                            'params'=>['item-vat_tax_rate'],
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= Html::hiddenInput('item-vat_number', '', ['id'=>'item-vat_number']) ?>
                    <?= $form->field($itemModel, 'vat_number')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                            'params'=>['item-vat_number'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
                <div class="col-sm-3">
                    <?= Html::hiddenInput('item-vat_subtotal', '', ['id'=>'item-vat_subtotal']) ?>
                    <?= $form->field($itemModel, 'vat_subtotal')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                            'params'=>['item-vat_subtotal'],
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= Html::hiddenInput('item-vat_taxes', '', ['id'=>'item-vat_taxes']) ?>
                    <?= $form->field($itemModel, 'vat_taxes')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                            'params'=>['item-vat_taxes'],
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= Html::hiddenInput('item-vat_total', '', ['id'=>'item-vat_total']) ?>
                    <?= $form->field($itemModel, 'vat_total')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['euvat-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $fieldsUrl,
                            'params'=>['item-vat_total'],
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
            </div>
        </fieldset>

    <?php endif; ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ?
            Yii::t('app', 'Create') :
            Yii::t('app', 'Update'), [
                'class' =>  'btn btn-primary'
            ]
        ) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<?php

/**
 * Conditional Logic
 */

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int)!$model->isNewRecord;

$script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#euvat-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['euvat-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

$this->registerJs($script, $this::POS_END, 'euvat-conditions');

$this->registerCss("legend { margin-top: 20px; }");

/**
 * Field Mapping
 */

if ($model->isNewRecord || count($model->items) === 0) {
    $script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="EuVatItem[vat_number]"]')
                    .attr('name', 'EuVatItem[' + item + '][vat_number]')
                    .attr('id', 'euvatitem-' + item + '-vat_number')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['euvat-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
                .find('[name="EuVatItem[country_code]"]')
                    .attr('name', 'EuVatItem[' + item + '][country_code]')
                    .attr('id', 'euvatitem-' + item + '-country_code')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['euvat-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
                .find('[name="EuVatItem[vat_tax_rate]"]')
                    .attr('name', 'EuVatItem[' + item + '][vat_tax_rate]')
                    .attr('id', 'euvatitem-' + item + '-vat_tax_rate')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['euvat-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
                .find('[name="EuVatItem[vat_subtotal]"]')
                    .attr('name', 'EuVatItem[' + item + '][vat_subtotal]')
                    .attr('id', 'euvatitem-' + item + '-vat_subtotal')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['euvat-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
                .find('[name="EuVatItem[vat_taxes]"]')
                    .attr('name', 'EuVatItem[' + item + '][vat_taxes]')
                    .attr('id', 'euvatitem-' + item + '-vat_taxes')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['euvat-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
                .find('[name="EuVatItem[vat_total]"]')
                    .attr('name', 'EuVatItem[' + item + '][vat_total]')
                    .attr('id', 'euvatitem-' + item + '-vat_total')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['euvat-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

} else {

    $script = <<<JS

$(window).on('load', function() {
    $('#euvat-form_id').trigger('depdrop.change');
});

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="EuVatItem[vat_number]"]')
                    .attr('name', 'EuVatItem[' + item + '][vat_number]')
                    .attr('id', 'euvatitem-' + item + '-vat_number')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['euvat-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
                .find('[name="EuVatItem[country_code]"]')
                    .attr('name', 'EuVatItem[' + item + '][country_code]')
                    .attr('id', 'euvatitem-' + item + '-country_code')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['euvat-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
                .find('[name="EuVatItem[vat_tax_rate]"]')
                    .attr('name', 'EuVatItem[' + item + '][vat_tax_rate]')
                    .attr('id', 'euvatitem-' + item + '-vat_tax_rate')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['euvat-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
                .find('[name="EuVatItem[vat_subtotal]"]')
                    .attr('name', 'EuVatItem[' + item + '][vat_subtotal]')
                    .attr('id', 'euvatitem-' + item + '-vat_subtotal')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['euvat-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
                .find('[name="EuVatItem[vat_taxes]"]')
                    .attr('name', 'EuVatItem[' + item + '][vat_taxes]')
                    .attr('id', 'euvatitem-' + item + '-vat_taxes')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['euvat-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
                .find('[name="EuVatItem[vat_total]"]')
                    .attr('name', 'EuVatItem[' + item + '][vat_total]')
                    .attr('id', 'euvatitem-' + item + '-vat_total')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['euvat-form_id'],
                        url: '{$fieldsUrl}'
                    })
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
}

$this->registerJs($script, $this::POS_END);

?>