<?php

namespace app\modules\addons\modules\eu_vat\services;

use app\components\analytics\enricher\IpLookupsEnrichment;
use Yii;
use yii\helpers\Url;

/**
 * Class EuVatService
 * @package app\modules\addons\modules\eu_vat\services
 */
class EuVatService
{
    public $calculator = null;

    /**
     * EuVatService constructor.
     */
    public function __construct()
    {
        require_once(Yii::getAlias('@addons/eu_vat/services/vendor/autoload.php'));

        $this->calculator = new \Mpociot\VatCalculator\VatCalculator();
    }

    /**
     * Finds the client IP address.
     *
     * @return mixed
     */
    public function getClientIP()
    {
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR']) && $_SERVER['HTTP_X_FORWARDED_FOR']) {
            $clientIpAddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } elseif (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR']) {
            $clientIpAddress = $_SERVER['REMOTE_ADDR'];
        } else {
            $clientIpAddress = '';
        }

        return $clientIpAddress;
    }

    /**
     * @return bool|string
     */
    public function getIPBasedCountry()
    {
        // return $this->calculator->getIPBasedCountry();
        $ipEnriched = new IpLookupsEnrichment($this->getClientIP());
        $geoLocation = $ipEnriched->getGeoLocation();
        return $geoLocation->country->isoCode ?? false;
    }

    /**
     * @param $code
     */
    public function setBusinessCountryCode($code)
    {
        $this->calculator->setBusinessCountryCode($code);
    }

    /**
     * @param $company
     */
    public function setCompany($company)
    {
        $this->calculator->setCompany($company);
    }

    /**
     * @param $netPrice
     * @param null|string $countryCode
     * @param null|string $postalCode
     * @param null|bool $isCompany
     * @return float|int
     */
    public function calculate($netPrice, $countryCode = null, $postalCode = null, $isCompany = null)
    {
        return $this->calculator->calculate($netPrice, $countryCode, $postalCode, $isCompany);
    }

    /**
     * @param $countryCode
     * @param null $postalCode
     * @param false $company
     * @param null $type
     * @return float|int
     */
    public function getTaxRateForLocation($countryCode, $postalCode = null, $company = false, $type = null)
    {
        return $this->calculator->getTaxRateForLocation($countryCode, $postalCode, $company, $type);
    }

    /**
     * @return float|int
     */
    public function getTaxRate()
    {
        return $this->calculator->getTaxRate();
    }

    /**
     * @return float
     */
    public function getNetPrice()
    {
        return $this->calculator->getNetPrice();
    }

    /**
     * @return float|int
     */
    public function getTaxValue()
    {
        return $this->calculator->getTaxValue();
    }

    /**
     * @param $code
     * @return bool
     */
    public function shouldCollectVAT($code)
    {
        return $this->calculator->shouldCollectVAT($code);
    }

    /**
     * @param $number
     * @return bool
     * @throws \Mpociot\VatCalculator\Exceptions\VATCheckUnavailableException
     */
    public function isValidVATNumber($number)
    {
        return $this->calculator->isValidVATNumber($number);
    }

    /**
     * @param $number
     * @return false|object
     * @throws \Mpociot\VatCalculator\Exceptions\VATCheckUnavailableException
     */
    public function getVATDetails($number)
    {
        return $this->calculator->getVATDetails($number);
    }
}