<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\eu_vat\models;

use Yii;

/**
 * This is the model class for table "{{%addon_eu_vat_item}}".
 *
 * @property integer $id
 * @property integer $eu_vat_id
 * @property integer $form_id
 * @property string $amount
 * @property string $country_code
 * @property string $postal_code
 * @property string $vat_number
 * @property string $vat_subtotal
 * @property string $vat_tax_rate
 * @property string $vat_taxes
 * @property string $vat_total
 */
class EuVatItem extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_eu_vat_item}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['eu_vat_id', 'form_id'], 'integer'],
            [['amount', 'country_code', 'postal_code', 'vat_number', 'vat_subtotal', 'vat_tax_rate', 'vat_taxes', 'vat_total'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'eu_vat_id' => Yii::t('app', 'EuVat ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'amount' => Yii::t('app', 'Amount'),
            'country_code' => Yii::t('app', 'Country'),
            'postal_code' => Yii::t('app', 'Postal Code'),
            'vat_number' => Yii::t('app', 'Validate VAT Number'),
            'vat_subtotal' => Yii::t('app', 'Net Amount'),
            'vat_tax_rate' => Yii::t('app', 'VAT Tax Rate'),
            'vat_taxes' => Yii::t('app', 'VAT Amount'),
            'vat_total' => Yii::t('app', 'Gross Amount'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getEuVat()
    {
        return $this->hasOne(EuVat::class,['eu_vat_id'=>'id']);
    }
}
