<?php

use yii\db\Migration;

/**
 * Class m210619_145952_eu_vat_1_0
 */
class m210619_145952_eu_vat_1_0 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_eu_vat}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(0),
            'name' => $this->text()->notNull(),
            'event' => $this->integer()->notNull()->defaultValue(1),
            'conditions' => $this->text(),

            'business_country_code' => $this->string(2),
            'rules' => $this->text(),
            'ip_based_country' => $this->boolean()->notNull()->defaultValue(0),

            'created_by' => $this->integer(11),
            'updated_by' => $this->integer(11),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_eu_vat_item}}', [
            'id' => $this->primaryKey(),
            'eu_vat_id' => $this->integer(11),
            'form_id' => $this->integer(11),
            // To calculate
            'amount' => $this->text(),
            'country_code' => $this->text(),
            'postal_code' => $this->text(),
            // To Validate
            'vat_number' => $this->text(),
            // To display calculations
            'vat_subtotal' => $this->text(),
            'vat_tax_rate' => $this->text(),
            'vat_taxes' => $this->text(),
            'vat_total' => $this->text(),
        ], $tableOptions);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%addon_eu_vat}}');
        $this->dropTable('{{%addon_eu_vat_item}}');
    }
}
