<?php

namespace app\modules\addons\modules\eu_vat\controllers;

use app\modules\addons\modules\eu_vat\services\EuVatService;
use Yii;
use yii\web\Response;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use app\modules\addons\modules\eu_vat\models\EuVat;

class CheckController extends Controller
{
    public $enableCsrfValidation = false;

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'tax-rate' => ['post'],
                ],
            ],
        ];
    }

	/**
	 * Validate an Email Address
     *
	 * @param $id
	 * @throws NotFoundHttpException
	 * @throws \Exception
	 */
    public function actionTaxRate($id)
    {
        $model = $this->findModel($id);
        $countryCode = Yii::$app->request->post('country_code');
        $vatNumber = Yii::$app->request->post('vat_number');
        $netAmount = Yii::$app->request->post('net_amount');
        $taxes = 0;
        $taxRate = 0;
        $grossAmount = 0;
        $company = false;

        $service = new EuVatService();

        if (!empty($model->business_country_code)) {
            $service->setBusinessCountryCode($model->business_country_code);
        }

        if (!empty($vatNumber)) {
            $details = $service->getVATDetails($vatNumber);

            if ($details) {
                $company = is_array($details) ? isset($details['vatNumber']) : $details->valid;
                if ($company) {
                    $countryCode = is_array($details) ? $details['countryCode'] : $details->countryCode;
                }
            }
        }

        if (!empty($countryCode)) {
            if ($service->shouldCollectVAT($countryCode)) {
                $taxRate = $service->getTaxRateForLocation($countryCode, null, $company);
            }
        }

        if (!empty($netAmount)) {
            $taxes = round($netAmount * $taxRate, 2);
            $grossAmount = $taxes + $netAmount;
        }

        /** @var \yii\web\Response $response */
        $response = Yii::$app->getResponse();
        $response->format = Response::FORMAT_JSON;
        $response->data = [
            'tax_rate' => $taxRate,
            'gross_amount' => $grossAmount,
            'taxes' => $taxes,
        ];
        $response->send();
        exit;
    }

    /**
     * Finds the model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     *
     * @param integer $id EuVat ID
     * @return EuVat the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = EuVat::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}