<?php

use app\components\widgets\ConditionsBuilder;
use yii\helpers\Html;
use yii\helpers\Url;
use kartik\form\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\emailoctopus\models\EmailOctopus */
/* @var $fieldModel app\modules\addons\modules\emailoctopus\models\EmailOctopusField */
/* @var $form yii\widgets\ActiveForm */
/* @var $forms array [id => name] of Form models */
/* @var $lists array [id => name] of Subscriber Lists */
/* @var $connected boolean The connection to EmailOctopus has been established */

$formFieldUrl = Url::to(['/addons/emailoctopus/admin/fields']);
$listFieldUrl = Url::to(['/addons/emailoctopus/admin/list-fields']);
?>

<div class="emailoctopus-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'api_key')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <span class="help-block">
                <span class="label label-default"><?= Yii::t('app', 'Note') ?></span>
                <?= Yii::t(
                    'app',
                    'For connecting to your EmailOctopus account you need API access.'
                ) ?>
                <?= Html::a(Yii::t('app', 'Go to EmailOctopus'), 'https://www.emailoctopus.com', ['target' => '_blank']) ?>.
            </span>
        </div>
    </div>

    <?php if ($connected && !empty($model->api_key)): ?>

        <div class="row">
            <div class="col-sm-12">
                <?= $form->field($model, 'name')->textInput([
                    'placeholder' => Yii::t('app', "Enter a configuration name..."),
                    'maxlength' => true,
                ]) ?>
            </div>
        </div>

        <div class="row" style="margin-top: 20px;">
            <div class="col-sm-6">
                <?= $form->field($model, 'form_id')->widget(Select2::class, [
                    'data' => $forms,
                    'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ])->label(Yii::t('app', 'Form')); ?>
            </div>
            <div class="col-sm-6">
                <?= $form->field($model, 'contact_list')->widget(Select2::class, [
                    'data' => $lists,
                    'options' => [
                        'placeholder' => Yii::t('app', 'Select a list...'),
                    ],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ])->hint( Yii::t(
                    'app',
                    'Select the list in which you want to add subscribers.'
                ))->label(Yii::t('app', 'List')); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'event')->widget(Select2::class, [
                    'data' => \app\helpers\EventHelper::supportedFormEvents(),
                ]); ?>
            </div>
            <div class="col-sm-6">
                <?php if ($model->isNewRecord) { $model->status = 1;} ?>
                <?= $form->field($model, 'status')->widget(SwitchInput::class)->hint(Yii::t(
                    'app',
                    'Disables the integration at any time.'
                )) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <?= ConditionsBuilder::widget([
                    'label' => Yii::t('app', 'Conditions'),
                ]) ?>
                <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
            </div>
        </div>

        <div class="row" style="margin-top: 20px">
            <div class="col-sm-6">
                <?= Html::hiddenInput('subscriber-email', $model->subscriber_email, ['id'=>'subscriber-email']) ?>
                <?= $form->field($model, 'subscriber_email')->widget(DepDrop::class, [
                    'pluginOptions' => [
                        'depends' => ['emailoctopus-form_id'],
                        'placeholder' => Yii::t('app', 'Select...'),
                        'url' => $formFieldUrl,
                        'params' => ['subscriber-email']
                    ]
                ]) ?>
            </div>
            <div class="col-sm-6">
                <?= $form->field($model, 'subscriber_status')->dropDownList([
                    'SUBSCRIBED' => Yii::t('app', 'Subscribed'),
                    'UNSUBSCRIBED' => Yii::t('app', 'Unsubscribed'),
                    'PENDING' => Yii::t('app', 'Pending'),
                ], ['prompt'=> Yii::t('app', 'Select...')]); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <legend><?= Yii::t('app', 'Field Mapping') ?></legend>
            </div>
        </div>

        <?php if ($model->isNewRecord || count($model->items) === 0): ?>

            <fieldset class="item">
                <div class="row">
                    <div class="col-sm-6">
                        <?= $form->field($fieldModel, '[0]form_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['emailoctopus-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $formFieldUrl,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= $form->field($fieldModel, '[0]list_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['emailoctopus-contact_list'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $listFieldUrl,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 25px;">
                            <button type="button" class="btn btn-default btn-add">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </fieldset>

            <fieldset id="itemTemplate" class="d-none">
                <div class="row">
                    <div class="col-sm-6">
                        <?= $form->field($fieldModel, 'form_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['emailoctopus-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $formFieldUrl,
                                'initialize' => true,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= $form->field($fieldModel, 'list_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['emailoctopus-contact_list'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $listFieldUrl,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 25px;">
                            <button type="button" class="btn btn-default btn-remove">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </fieldset>

        <?php else: ?>

            <?php foreach($model->items as $i => $item): ?>
                <fieldset class="item">
                    <div class="row">
                        <div class="col-sm-6">
                            <?= Html::hiddenInput('item-'.$i.'-form_field',
                                $item->form_field, ['id'=>'item-'.$i.'-form_field']) ?>
                            <?= $form->field($fieldModel, '['.$i.']form_field')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['emailoctopus-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $formFieldUrl,
                                    'params'=>['item-'.$i.'-form_field'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-5">
                            <?= Html::hiddenInput('item-'.$i.'-list_field', $item->list_field, ['id'=>'item-'.$i.'-list_field']) ?>
                            <?= $form->field($fieldModel, '['.$i.']list_field')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['emailoctopus-contact_list'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $listFieldUrl,
                                    'params' => ['item-'.$i.'-list_field']
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-1">
                            <button type="button" class="btn btn-default btn-remove" style="margin-top: 25px;">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </fieldset>
            <?php endforeach; ?>

            <fieldset id="itemTemplate" class="d-none">
                <div class="row">
                    <div class="col-sm-6">
                        <?= Html::hiddenInput('item-form_field', '', ['id'=>'item-form_field']) ?>
                        <?= $form->field($fieldModel, 'form_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['emailoctopus-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $formFieldUrl,
                                'params'=>['item-form_field'],
                                'initialize' => true,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= Html::hiddenInput('item-list_field', '', ['id'=>'item-list_field']) ?>
                        <?= $form->field($fieldModel, 'list_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['emailoctopus-contact_list'],
                                'initialize' => true,
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $listFieldUrl,
                                'params'=>['item-list_field'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-default btn-remove" style="margin-top: 25px;">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </fieldset>

        <?php endif; ?>

    <?php endif; ?>

    <div class="form-group" style="margin-top: 20px">
        <?= Html::submitButton( !$connected ?
            ' <i class="far fa-external-link-square"></i> ' . Yii::t('app', 'Connect to EmailOctopus'):
            ' <i class="fas fa-check"></i> ' . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>


<?php

$this->registerCss("legend { margin-top: 20px; }");

/**
 * Conditional Logic
 */

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int)!$model->isNewRecord;

$script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#emailoctopus-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['emailoctopus-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

$this->registerJs($script, $this::POS_END, 'emailoctopus-conditions');

/**
 * Field Mapping
 */

if ($model->isNewRecord || count($model->items) === 0) {
    $script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update name attribute
            cloned
                .find('[name="EmailOctopusField[form_field]"]')
                    .attr('name', 'EmailOctopusField[' + item + '][form_field]')
                    .attr('id', 'emailoctopusfield-' + item + '-form_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['emailoctopus-form_id'],
                        url: '{$formFieldUrl}'
                    })
                    .end()
                .find('[name="EmailOctopusField[list_field]"]')
                    .attr('name', 'EmailOctopusField[' + item + '][list_field]')
                    .attr('id', 'emailoctopusfield-' + item + '-list_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['emailoctopus-contact_list'],
                        url: '$listFieldUrl'
                    })
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

} else {

    $script = <<<JS

$(window).on('load', function() {
    $('#emailoctopus-form_id').trigger('depdrop.change');
    $('#emailoctopus-contact_list').trigger('depdrop.change');
});

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            // Update name attribute
            cloned
                .find('[name="EmailOctopusField[form_field]"]')
                    .attr('name', 'EmailOctopusField[' + item + '][form_field]')
                    .attr('id', 'emailoctopusfield-' + item + '-form_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['emailoctopus-form_id'],
                        url: '{$formFieldUrl}'
                    })
                    .end()
                .find('[name="EmailOctopusField[list_field]"]')
                    .attr('name', 'EmailOctopusField[' + item + '][list_field]')
                    .attr('id', 'emailoctopusfield-' + item + '-list_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['emailoctopus-contact_list'],
                        url: '{$listFieldUrl}'
                    })
                    .end()

            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
}

$this->registerJs($script, $this::POS_END);

?>