<?php

namespace app\modules\addons\modules\emailoctopus\services;

use Exception;
use yii\helpers\Json;

class EmailOctopusService
{

    /** @var string Api Key */
    protected $apiKey;

    /** @var string Base Url */
    protected $baseUrl = "https://emailoctopus.com/api/1.5";

    /** @var string Response Format */
    protected $returnFormat = "json";

    /** @var bool Check Header */
    protected $checkHeader = true;

    /** @var bool Throw Exceptions */
    protected $throwExceptions = true;

    /** @var bool Header */
    protected $header = false;

    /** @var bool Error */
    protected $error = false;

    /**
     * EmailOctopusService constructor.
     * @param $apiKey
     * @throws Exception
     */
    public function __construct($apiKey)
    {
        if (empty($apiKey)) {
            throw new Exception('The api key is empty');
        }
        $this->apiKey = $apiKey;
    }

    /**
     * Add or Edit Subscriber
     *
     * @param int $groupId
     * @param array $contact
     * @return array|false
     * @throws Exception
     */
    public function syncContact($listId, $contact)
    {
        $contact['api_key'] = $this->apiKey;
        $contact = (is_array($contact)) ? Json::encode($contact) : $contact;
        $options = [
            CURLOPT_URL => $this->baseUrl . "/lists/{$listId}/contacts",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => false,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/json"
            ),
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $contact,
            CURLINFO_HEADER_OUT => true,
        ];
        return (array) $this->request($options);
    }

    /**
     * Get Subscriber Lists
     *
     * @return array
     * @throws Exception
     */
    public function getSubscriberLists()
    {
        $options = [
            CURLOPT_URL => $this->baseUrl . "/lists?api_key={$this->apiKey}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => false,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/json"
            ),
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLINFO_HEADER_OUT => true,
        ];

        $listCollection  =  (array) $this->request($options);

        $lists = [];
        if (is_array($listCollection['data']) && !empty($listCollection['data'])) {
            foreach($listCollection['data'] as $list) {
                $list = (array) $list;
                if (isset($list['id'], $list['name'])) {
                    $lists[$list['id']] = $list['name'];
                }
            }
        }

        return $lists;
    }

    /**
     * Get Custom Fields
     *
     * @param int $listId
     * @return array
     * @throws Exception
     */
    public function getCustomFields($listId)
    {
        $options = [
            CURLOPT_URL => $this->baseUrl . "/lists/{$listId}?api_key={$this->apiKey}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HEADER => false,
            CURLOPT_HTTPHEADER => array(
                "cache-control: no-cache",
                "content-type: application/json"
            ),
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLINFO_HEADER_OUT => true,
        ];

        $customFieldCollection  =  (array) $this->request($options);

        $fields = [];
        if (is_array($customFieldCollection["fields"]) && !empty($customFieldCollection["fields"])) {
            foreach($customFieldCollection["fields"] as $customField) {
                $customField = (array) $customField;
                if (isset($customField['tag'], $customField['label']) && !($customField['tag'] === 'EmailAddress')) {
                    $fields[$customField['tag']] = $customField['label'];
                }
            }
        }
        return $fields;
    }

    /**
     * Return formatted response according to settings
     *
     * @param $in
     * @param bool $header
     * @return mixed|null
     * @throws Exception
     */
    protected function response($in, $header = false)
    {
        $this->header = $header;

        if ($this->checkHeader && isset($header["http_code"])) {
            if ($header["http_code"] < 200 || $header["http_code"] >= 300) {
                //error!?
                $this->error = $in;
                $message = var_export($in, true);
                if ($tmp = json_decode($in)) {
                    if (isset($tmp->error->message)) {
                        $message = $tmp->error->message;
                    }
                }
                if ($this->throwExceptions) {
                    throw new \Exception('' . $header["http_code"] . ';' . $message);
                }
                $in = null;

            }

        }

        switch ($this->returnFormat) {
            case 'json':
                return json_decode($in);
                break;

            default:
                return $in;
                break;
        }
        return $in;
    }

    /**
     * @param $options
     * @return mixed|null
     * @throws Exception
     */
    protected function request($options)
    {
        $curl = curl_init();
        curl_setopt_array($curl, $options);
        $response = curl_exec($curl);
        $info =  curl_getinfo($curl);
        curl_close($curl);

        return $this->response($response, $info);
    }

}