<?php

namespace app\modules\addons\modules\emailoctopus\models;

use Yii;

/**
 * This is the model class for table "{{%addon_emailoctopus_item}}".
 *
 * @property integer $id
 * @property integer $emailoctopus_id
 * @property integer $form_id
 * @property string $form_field
 * @property string $list_field
 */
class EmailOctopusField extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_emailoctopus_field}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['emailoctopus_id', 'form_id'], 'integer'],
            [['form_field', 'list_field'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'emailoctopus_id' => Yii::t('app', 'EmailOctopus ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'form_field' => Yii::t('app', 'Form Field'),
            'list_field' => Yii::t('app', 'List Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getEmailOctopus()
    {
        return $this->hasOne(EmailOctopus::class,['emailoctopus_id'=>'id']);
    }
}
