<?php

use app\modules\addons\modules\data_validation\models\DataValidationItem;
use yii\helpers\Html;
use yii\helpers\Url;
use kartik\form\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $form kartik\form\ActiveForm */
/* @var $model app\modules\addons\modules\data_validation\models\DataValidation */
/* @var $itemModel app\modules\addons\modules\data_validation\models\DataValidationItem */
/* @var $forms array [id => name] of Form models */

$url = Url::to(['/addons/data_validation/admin/fields']);

if ($model->isNewRecord) {
    $model->status = 1;
}
?>

<div class="data_validation-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'form_id')->widget(Select2::class, [
                'data' => $forms,
                'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(Yii::t('app', 'Form')); ?>
        </div>
        <div class="col-sm-6">
            <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <legend><?= Yii::t('app', 'Field Mapping') ?></legend>
        </div>
    </div>

    <?php if ($model->isNewRecord || count($model->items) === 0): ?>

        <fieldset class="item">
            <div class="row">
                <div class="col-sm-2">
                    <?= $form->field($itemModel, '[0]field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['datavalidation-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, '[0]validation_rule')->dropDownList(
                        DataValidationItem::getValidationRules()
                    ) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, '[0]validation_field')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['datavalidation-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                        ]
                    ])->label(Yii::t('app', 'Validation Field')
                        . ' '
                        . Html::tag('small', Html::tag('span', '', [
                            'class' => 'fas fa-question-circle',
                            'style' => '',
                        ]), [
                            'data-toggle' => 'tooltip',
                            'data-placement'=> 'top',
                            'title' => Yii::t(
                                'app',
                                '(Optional) The validation field is used to compare its input value with the first field and make sure if their relationship is as specified by the validation rule.'
                            ),
                            'class' => 'text'
                        ])
                    ) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, '[0]field_message')->textInput([
                        'maxlength' => true,
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-icon btn-default btn-add">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                </div>
                <div class="col-sm-12 field-values-container">
                    <div class="form-group">
                        <label class="control-label" style="width: 100%;">
                            <?= Yii::t('app', 'Field Values') ?>
                            <?= Html::tag('small', Html::tag('span', '', [
                                    'class' => 'fas fa-question-circle',
                                    'style' => '',
                                ]), [
                                    'data-toggle' => 'tooltip',
                                    'data-placement'=> 'top',
                                    'title' => Yii::t(
                                        'app',
                                        '(Optional) These values are used to compare them against the input value and make sure if their relationship is as specified by the validation rule.'
                                    ),
                                    'class' => 'text'
                                ]) ?>
                            <div class="checkbox text-muted pull-right" style="margin: 0">
                                <label>
                                    <input type="checkbox" class="upload-csv-file"> <?= Yii::t('app', 'Upload CSV File') ?>
                                </label>
                            </div>
                        </label>
                        <div class="textarea-field">
                            <?= $form->field($itemModel, '[0]field_values')->textarea()->label(false); ?>
                        </div>
                        <div class="csv-field" style="display: none">
                            <?= $form->field($itemModel, '[0]field_values')->fileInput()->label(false); ?>
                        </div>
                    </div>
                </div>
            </div>
        </fieldset>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['datavalidation-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'validation_rule')->dropDownList(
                        DataValidationItem::getValidationRules(),
                        [
                            'disabled' => true,
                        ]
                    ) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'validation_field')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['datavalidation-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ])->label(Yii::t('app', 'Validation Field')
                        . ' '
                        . Html::tag('small', Html::tag('span', '', [
                            'class' => 'fas fa-question-circle',
                            'style' => '',
                        ]), [
                            'data-toggle' => 'tooltip',
                            'data-placement'=> 'top',
                            'title' => Yii::t(
                                'app',
                                '(Optional) The validation field is used to compare its input value with the first field and make sure if their relationship is as specified by the validation rule.'
                            ),
                            'class' => 'text'
                        ])
                    ) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, 'field_message')->textInput([
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-icon btn-default btn-remove">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="col-sm-12 field-values-container">
                    <div class="form-group">
                        <label class="control-label" style="width: 100%;">
                            <?= Yii::t('app', 'Field Values') ?>
                            <?= Html::tag('small', Html::tag('span', '', [
                                'class' => 'fas fa-question-circle',
                                'style' => '',
                            ]), [
                                'data-toggle' => 'tooltip',
                                'data-placement'=> 'top',
                                'title' => Yii::t(
                                    'app',
                                    '(Optional) These values are used to compare them against the input value and make sure if their relationship is as specified by the validation rule.'
                                ),
                                'class' => 'text'
                            ]) ?>
                            <div class="checkbox text-muted pull-right" style="margin: 0">
                                <label>
                                    <input type="checkbox" class="upload-csv-file"> <?= Yii::t('app', 'Upload CSV File') ?>
                                </label>
                            </div>
                        </label>
                        <div class="textarea-field">
                            <?= $form->field($itemModel, 'field_values')->textarea()->label(false); ?>
                        </div>
                        <div class="csv-field" style="display: none">
                            <?= $form->field($itemModel, 'field_values')->fileInput()->label(false); ?>
                        </div>
                    </div>
                </div>
            </div>
        </fieldset>

    <?php else: ?>

        <?php foreach($model->items as $i => $item): ?>

            <fieldset class="item">
                <div class="row">
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('item-'.$i.'-field_id',
                            $item->field_id, ['id'=>'item-'.$i.'-field_id']) ?>
                        <?= $form->field($item, '['.$i.']field_id')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['datavalidation-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['item-'.$i.'-field_id'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($item, '['.$i.']validation_rule')->dropDownList(
                            DataValidationItem::getValidationRules()
                        ) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('item-'.$i.'-validation_field',
                            $item->validation_field, ['id'=>'item-'.$i.'-validation_field']) ?>
                        <?= $form->field($item, '['.$i.']validation_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['datavalidation-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['item-'.$i.'-validation_field'],
                            ]
                        ])->label(Yii::t('app', 'Validation Field')
                            . ' '
                            . Html::tag('small', Html::tag('span', '', [
                                'class' => 'fas fa-question-circle',
                                'style' => '',
                            ]), [
                                'data-toggle' => 'tooltip',
                                'data-placement'=> 'top',
                                'title' => Yii::t(
                                    'app',
                                    '(Optional) The validation field is used to compare its input value with the first field and make sure if their relationship is as specified by the validation rule.'
                                ),
                                'class' => 'text'
                            ])
                        ) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= $form->field($item, '['.$i.']field_message')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                    <div class="col-sm-12 field-values-container">
                        <div class="form-group">
                            <label class="control-label" style="width: 100%;">
                                <?= Yii::t('app', 'Field Values') ?>
                                <?= Html::tag('small', Html::tag('span', '', [
                                    'class' => 'fas fa-question-circle',
                                    'style' => '',
                                ]), [
                                    'data-toggle' => 'tooltip',
                                    'data-placement'=> 'top',
                                    'title' => Yii::t(
                                        'app',
                                        '(Optional) These values are used to compare them against the input value and make sure if their relationship is as specified by the validation rule.'
                                    ),
                                    'class' => 'text'
                                ]) ?>
                                <div class="checkbox text-muted pull-right" style="margin: 0">
                                    <label>
                                        <input type="checkbox" class="upload-csv-file"> <?= Yii::t('app', 'Upload CSV File') ?>
                                    </label>
                                </div>
                            </label>
                            <div class="textarea-field">
                                <?php
                                $values = json_decode($item->field_values, true);
                                $values = is_array($values) ? $values : [];
                                $item->field_values = implode("\n", $values);
                                ?>
                                <?= $form->field($item, '['.$i.']field_values')->textarea(['placeholder' => Yii::t('app', 'Enter one value per row.')])->label(false); ?>
                            </div>
                            <div class="csv-field" style="display: none">
                                <?= $form->field($item, '['.$i.']field_values')->fileInput()->label(false); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </fieldset>

        <?php endforeach; ?>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-2">
                    <?= Html::hiddenInput('item-field_id', '', ['id'=>'item-field_id']) ?>
                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['datavalidation-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                            'params'=>['item-field_id'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'validation_rule')->dropDownList(
                        DataValidationItem::getValidationRules(),
                        [
                            'disabled' => true,
                        ]
                    ) ?>
                </div>
                <div class="col-sm-2">
                    <?= Html::hiddenInput('item-validation_field', '', ['id'=>'item-validation_field']) ?>
                    <?= $form->field($itemModel, 'validation_field')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['datavalidation-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                            'params'=>['item-validation_field'],
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ])->label(Yii::t('app', 'Validation Field')
                        . ' '
                        . Html::tag('small', Html::tag('span', '', [
                            'class' => 'fas fa-question-circle',
                            'style' => '',
                        ]), [
                            'data-toggle' => 'tooltip',
                            'data-placement'=> 'top',
                            'title' => Yii::t(
                                'app',
                                '(Optional) The validation field is used to compare its input value with the first field and make sure if their relationship is as specified by the validation rule.'
                            ),
                            'class' => 'text'
                        ])
                    ) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, 'field_message')->textInput([
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
                <div class="col-sm-12 field-values-container">
                    <div class="form-group">
                        <label class="control-label" style="width: 100%;">
                            <?= Yii::t('app', 'Field Values') ?>
                            <?= Html::tag('small', Html::tag('span', '', [
                                'class' => 'fas fa-question-circle',
                                'style' => '',
                            ]), [
                                'data-toggle' => 'tooltip',
                                'data-placement'=> 'top',
                                'title' => Yii::t(
                                    'app',
                                    '(Optional) These values are used to compare them against the input value and make sure if their relationship is as specified by the validation rule.'
                                ),
                                'class' => 'text'
                            ]) ?>
                            <div class="checkbox text-muted pull-right" style="margin: 0">
                                <label>
                                    <input type="checkbox" class="upload-csv-file"> <?= Yii::t('app', 'Upload CSV File') ?>
                                </label>
                            </div>
                        </label>
                        <div class="textarea-field">
                            <?= $form->field($itemModel, 'field_values')->textarea()->label(false); ?>
                        </div>
                        <div class="csv-field" style="display: none">
                            <?= $form->field($itemModel, 'field_values')->fileInput()->label(false); ?>
                        </div>
                    </div>
                </div>
            </div>
        </fieldset>

    <?php endif; ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ?
            Yii::t('app', 'Save') :
            Yii::t('app', 'Update'), ['class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<?php

$this->registerCss("legend { margin-top: 20px; }");

$js = <<< 'SCRIPT'

$(function () {
    // Tooltips
    $("[data-toggle='tooltip']").tooltip();
});

SCRIPT;
$this->registerJs($js);

/**
 * Field Mapping
 */

if ($model->isNewRecord || count($model->items) === 0) {

    $script = <<<JS

$(document).ready(function(){

    $('.csv-field input').attr('disabled', true);
    
    $('body').on('click', '.upload-csv-file', function(e){
        var container = $(e.currentTarget).closest('.field-values-container');
        container.find('.textarea-field').toggle();
        container.find('.csv-field').toggle();
        container.find('textarea').attr('disabled', function(i, v) { return !v; });
        container.find('input[type=hidden], input[type=file]').attr('disabled', function(i, v) { return !v; });
    });

    var item = 0;

    $('#itemTemplate')
        .find('[name="DataValidationItem[field_values]"]')
        .attr('disabled', true);

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="DataValidationItem[field_id]"]')
                    .attr('name', 'DataValidationItem[' + item + '][field_id]')
                    .attr('id', 'datavalidationitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['datavalidation-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="DataValidationItem[validation_rule]"]')
                    .attr('name', 'DataValidationItem[' + item + '][validation_rule]')
                    .attr('id', 'datavalidationitem-' + item + '-validation_rule')
                    .removeAttr('disabled')
                    .end()
                .find('[name="DataValidationItem[validation_field]"]')
                    .attr('name', 'DataValidationItem[' + item + '][validation_field]')
                    .attr('id', 'datavalidationitem-' + item + '-validation_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['datavalidation-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="DataValidationItem[field_message]"]')
                    .attr('name', 'DataValidationItem[' + item + '][field_message]')
                    .attr('id', 'datavalidationitem-' + item + '-field_message')
                    .removeAttr('disabled')
                    .end()
                .find('[name="DataValidationItem[field_values]"]')
                    .attr('name', 'DataValidationItem[' + item + '][field_values]')
                    .attr('id', 'datavalidationitem-' + item + '-field_values')
                    .end()
                .find('textarea')
                    .removeAttr('disabled')
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

} else {

    $script = <<<JS

$(window).on('load', function() {
    $('#datavalidation-form_id').trigger('depdrop.change');
});

$(document).ready(function(){

    $('.csv-field input').attr('disabled', true);

    $('body').on('click', '.upload-csv-file', function(e){
        var container = $(e.currentTarget).closest('.field-values-container');
        container.find('.textarea-field').toggle();
        container.find('.csv-field').toggle();
        container.find('textarea').attr('disabled', function(i, v) { return !v; });
        container.find('input[type=hidden], input[type=file]').attr('disabled', function(i, v) { return !v; });
    });
    
    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('#itemTemplate')
        .find('[name="DataValidationItem[field_values]"]')
        .attr('disabled', true);        

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            // Update the name attributes
            cloned
                .find('#item-field_id')
                    .attr('name', 'item-' + item + '-field_id')
                    .attr('id', 'item-' + item + '-field_id')
                    .end()
                .find('[name="DataValidationItem[field_id]"]')
                    .attr('name', 'DataValidationItem[' + item + '][field_id]')
                    .attr('id', 'datavalidationitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['datavalidation-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="DataValidationItem[validation_rule]"]')
                    .attr('name', 'DataValidationItem[' + item + '][validation_rule]')
                    .attr('id', 'datavalidationitem-' + item + '-validation_rule')
                    .removeAttr('disabled')
                    .end()
                .find('#item-validation_field')
                    .attr('name', 'item-' + item + '-validation_field')
                    .attr('id', 'item-' + item + '-validation_field')
                    .end()
                .find('[name="DataValidationItem[validation_field]"]')
                    .attr('name', 'DataValidationItem[' + item + '][validation_field]')
                    .attr('id', 'datavalidationitem-' + item + '-validation_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['datavalidation-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="DataValidationItem[field_message]"]')
                    .attr('name', 'DataValidationItem[' + item + '][field_message]')
                    .attr('id', 'datavalidationitem-' + item + '-field_message')
                    .removeAttr('disabled')
                    .end()
                .find('[name="DataValidationItem[field_values]"]')
                    .attr('name', 'DataValidationItem[' + item + '][field_values]')
                    .attr('id', 'datavalidationitem-' + item + '-field_values')
                    .end()
                .find('textarea')
                    .removeAttr('disabled')

            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
}

$this->registerJs($script, $this::POS_END);

?>