<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 */
namespace app\modules\addons\modules\data_validation\models;

use Yii;

/**
 * This is the model class for table "{{%addon_data_validation_item}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property string $field_id
 * @property string $field_values
 * @property string $field_message
 * @property string $validation_rule
 * @property string $validation_field
 *
 * @property DataValidation $dataValidation
 */
class DataValidationItem extends \yii\db\ActiveRecord
{
    const RULE_IS = 'IS';
    const RULE_IS_NOT = 'IS_NOT';
    const RULE_CONTAINS = 'CONTAINS';
    const RULE_DOES_NOT_CONTAIN = 'DOES_NOT_CONTAIN';
    const RULE_STARTS_WITH = 'STARTS_WITH';
    const RULE_ENDS_WITH = 'ENDS_WITH';

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_data_validation_item}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id'], 'integer'],
            [['field_id'], 'string', 'max' => 255],
            [['field_values', 'validation_rule'], 'string'],
            [['field_message'], 'string', 'max' => 2555],
            [['validation_field'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form'),
            'field_id' => Yii::t('app', 'Field'),
            'field_values' => Yii::t('app', 'Field Values'),
            'field_message' => Yii::t('app', 'Validation Message'),
            'validation_rule' => Yii::t('app', 'Validation Rule'),
            'validation_field' => Yii::t('app', 'Validation Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDataValidation()
    {
        return $this->hasOne(DataValidation::class,['form_id'=>'form_id']);
    }

    /**
     * Get Validation Rules
     *
     * @return array
     */
    public static function getValidationRules()
    {
        return [
            DataValidationItem::RULE_IS => Yii::t('app', 'Is'),
            DataValidationItem::RULE_IS_NOT => Yii::t('app', 'Is Not'),
            DataValidationItem::RULE_CONTAINS => Yii::t('app', 'Contains'),
            DataValidationItem::RULE_DOES_NOT_CONTAIN => Yii::t('app', 'Does Not Contain'),
            DataValidationItem::RULE_STARTS_WITH => Yii::t('app', 'Starts With'),
            DataValidationItem::RULE_ENDS_WITH => Yii::t('app', 'Ends With'),
        ];
    }
}