<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

use yii\db\Schema;
use yii\db\Migration;

class m160118_012839_init_addon_data_validation extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_data_validation}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(1),

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),

        ], $tableOptions);

        $this->createTable('{{%addon_data_validation_item}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'field_id' => $this->text(), // Form Field ID
            'field_values' => 'longtext', // MySql type
            'field_message' => $this->text(), // Field Values
        ], $tableOptions);
    }

    public function safeDown()
    {
        $this->dropTable('{{%addon_data_validation_item}}');
        $this->dropTable('{{%addon_data_validation}}');
    }
}
