<?php

use yii\helpers\Html;
use yii\helpers\Url;
use kartik\form\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $form kartik\form\ActiveForm */
/* @var $model app\modules\addons\modules\custom_error_message\models\CustomErrorMessage */
/* @var $itemModel app\modules\addons\modules\custom_error_message\models\CustomErrorMessageItem */
/* @var $forms array [id => name] of Form models */

$this->title = Yii::t('app', 'Update Form');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Custom Error Message'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Form') .' #'.
    $model->id, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = Yii::t('app', 'Update');

$url = Url::to(['/addons/custom_error_message/admin/fields']);

$options = array(
    "validationMessages" => $model->validationMessages,
);
$this->registerJs("var options = ".json_encode($options).";", $this::POS_BEGIN, 'custom-error-messages-options');

?>
    <!-- Page header -->
    <div class="page-header d-print-none">
        <div class="container-xl">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
                </div>
            </div>
        </div>
    </div>
    <div class="page-header d-print-none">
        <div class="container-xl">
            <div class="row">
                <div class="col">
                    <h2 class="page-title">
                        <?= Html::encode($this->title) ?>
                    </h2>
                </div>
            </div>
        </div>
    </div>
    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">
                                <?= Html::encode($this->title) ?>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php $form = ActiveForm::begin(); ?>
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= $form->field($model, 'form_id')->widget(Select2::class, [
                                        'data' => $forms,
                                        'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                                        'pluginOptions' => [
                                            'allowClear' => true
                                        ],
                                    ])->label(Yii::t('app', 'Form')); ?>
                                </div>
                                <div class="col-sm-6">
                                    <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <legend><?= Yii::t('app', 'Items') ?></legend>
                                </div>
                            </div>
                            <?php foreach($model->items as $i => $item): ?>
                                <fieldset class="item">
                                    <div class="row">
                                        <div class="col-sm-2">
                                            <?= Html::hiddenInput('item-'.$i.'-field_id',
                                                $item->field_id, ['id'=>'item-'.$i.'-field_id']) ?>
                                            <?= $form->field($item, '['.$i.']field_id')->widget(DepDrop::class, [
                                                'pluginOptions' => [
                                                    'depends' => ['customerrormessage-form_id'],
                                                    'placeholder' => Yii::t('app', 'Select...'),
                                                    'url' => Url::to(['/addons/custom_error_message/admin/fields']),
                                                    'params'=>['item-'.$i.'-field_id'],
                                                ]
                                            ]) ?>
                                        </div>
                                        <div class="col-sm-2">
                                            <?= $form->field($item, '['.$i.']field_validation_type')
                                                ->dropDownList($model->validationTypes, ['class' => 'form-control validation-type']); ?>
                                        </div>
                                        <div class="col-sm-7">
                                            <?= $form->field($item, '['.$i.']field_validation_message')->textInput([
                                                'maxlength' => true,
                                                'class' => 'form-control validation-message',
                                                'placeholder' => isset($model->validationMessages[$item->field_validation_type]) ?
                                                    $model->validationMessages[$item->field_validation_type] : null,
                                            ]) ?>
                                        </div>
                                        <div class="col-sm-1">
                                            <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                                                <i class="fas fa-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                </fieldset>
                            <?php endforeach; ?>
                            <fieldset id="itemTemplate" class="d-none">
                                <div class="row">
                                    <div class="col-sm-2">
                                        <?= Html::hiddenInput('item-field_id', '', ['id'=>'item-field_id']) ?>
                                        <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['customerrormessage-form_id'],
                                                'initialize' => true,
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => Url::to(['/addons/custom_error_message/admin/fields']),
                                                'params'=>['item-field_id'],
                                            ],
                                            'pluginEvents' => [
                                                "depdrop:afterChange" => "function(event, id, value) { 
                                                    $(event.currentTarget).attr('disabled', true)
                                                }",
                                            ],
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-2">
                                        <?= $form->field($itemModel, 'field_validation_type')
                                            ->dropDownList($model->validationTypes, ['disabled' => true, 'class' => 'form-control validation-type']); ?>
                                    </div>
                                    <div class="col-sm-7">
                                        <?= $form->field($itemModel, 'field_validation_message')->textInput([
                                            'maxlength' => true,
                                            'disabled' => true,
                                            'class' => 'form-control validation-message',
                                            'placeholder' => $model->validationMessages['REQUIRED'] ?? null,
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-1">
                                        <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                    </div>
                                </div>
                            </fieldset>
                            <div class="form-group">
                                <?= Html::submitButton(Yii::t('app', 'Update'), ['class' => 'btn btn-primary']) ?>
                            </div>
                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php

$this->registerCss("legend { margin-top: 20px; }");

$script = <<<JS

$(window).on('load', function() {
    $('#customerrormessage-form_id').trigger('depdrop.change');
});

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            // Update the name attributes
            cloned
                .find('[name="CustomErrorMessageItem[field_id]"]')
                    .attr('name', 'CustomErrorMessageItem[' + item + '][field_id]')
                    .attr('id', 'customerrormessageitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['customerrormessage-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-field_id')
                    .attr('name', 'item-' + item + '-field_id')
                    .attr('id', 'item-' + item + '-field_id')
                    .end()
                .find('[name="CustomErrorMessageItem[field_validation_type]"]')
                    .attr('name', 'CustomErrorMessageItem[' + item + '][field_validation_type]')
                    .attr('id', 'customerrormessageitem-' + item + '-field_validation_type')
                    .removeAttr('disabled')
                    .end()
                .find('[name="CustomErrorMessageItem[field_validation_message]"]')
                    .attr('name', 'CustomErrorMessageItem[' + item + '][field_validation_message]')
                    .attr('id', 'customerrormessageitem-' + item + '-field_validation_message')
                    .removeAttr('disabled')
                    .end()

            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

    /**
    * Change placeholder 
    */
    $('body').on('change', '.validation-type', function (e) {
        var validationTypeField = $(e.currentTarget);
        var validationMessageField = validationTypeField.closest('.row').find('.validation-message')
        var validationType = validationTypeField.val();
        if (typeof options.validationMessages[validationType] !== 'undefined') {
            validationMessageField.attr('placeholder', options.validationMessages[validationType])            
        }
    })
})

JS;
$this->registerJs($script, $this::POS_END);
?>