<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 */
namespace app\modules\addons\modules\custom_error_message\models;

use Yii;

/**
 * This is the model class for table "{{%addon_custom_error_message_item}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property string $field_id
 * @property string $field_validation_type
 * @property string $field_validation_message
 */
class CustomErrorMessageItem extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_custom_error_message_item}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id'], 'integer'],
            [['field_id', 'field_validation_type', 'field_validation_message'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form'),
            'field_id' => Yii::t('app', 'Field'),
            'field_validation_type' => Yii::t('app', 'Validation Type'),
            'field_validation_message' => Yii::t('app', 'Error Message'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCustomErrorMessage()
    {
        return $this->hasOne(CustomErrorMessage::class,['form_id'=>'form_id']);
    }
}