<?php

use yii\db\Migration;

/**
 * Class m181018_003634_init_addon_custom_error_message
 */
class m181018_003634_init_addon_custom_error_message extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_custom_error_message}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(1),

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),

        ], $tableOptions);

        $this->createTable('{{%addon_custom_error_message_item}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'field_id' => $this->text(), // Form Field ID
            'field_validation_type' => $this->text(), // Field Values
            'field_validation_message' => $this->text(), // Field Values
        ], $tableOptions);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%addon_custom_error_message_item}}');
        $this->dropTable('{{%addon_custom_error_message}}');
    }
}
