<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\constant_contact\models;

use Yii;

/**
 * This is the model class for table "addon_constant_contact_field".
 *
 * @property integer $id
 * @property integer $constant_contact_id
 * @property integer $form_id
 * @property string $form_field
 * @property string $list_field
 */
class ConstantContactField extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'addon_constant_contact_field';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'constant_contact_id'], 'integer'],
            [['form_field', 'list_field'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'constant_contact_id' => Yii::t('app', 'Constant Contact ID'),
            'form_id' => Yii::t('app', 'Form'),
            'form_field' => Yii::t('app', 'Form Field'),
            'list_field' => Yii::t('app', 'List Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getConstantContact()
    {
        return $this->hasOne(ConstantContact::class,['id'=>'constant_contact_id']);
    }
}