<?php

use yii\db\Migration;

/**
 * Class m200627_171759_update_to_1_4
 */
class m200627_171759_update_to_1_4 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Add Conditional logic fields
        $this->addColumn('{{%addon_constant_contact}}', 'name', $this->text()->notNull()->after('status'));
        $this->addColumn('{{%addon_constant_contact}}', 'event', $this->integer()->notNull()->defaultValue(1)->after('name'));
        $this->addColumn('{{%addon_constant_contact}}', 'conditions', $this->text()->after('event'));

        // Add foreign column to fields
        $this->addColumn('{{%addon_constant_contact_field}}', 'constant_contact_id', $this->integer(11)->notNull()->after('id'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_constant_contact_field}}', 'constant_contact_id');

        $this->dropColumn('{{%addon_constant_contact}}', 'event');
        $this->dropColumn('{{%addon_constant_contact}}', 'conditions');
        $this->dropColumn('{{%addon_constant_contact}}', 'name');
    }
}
