<?php

use yii\db\Migration;

class m170404_135121_init_addon_constant_contact extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_constant_contact}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(1),
            // Authorization
            'access_token' => $this->text()->notNull(),
            'expires_in' => $this->text()->notNull(),
            // Required Information
            'list_id' => $this->text()->notNull(),
            'list_name' => $this->text()->notNull(),
            'subscriber_email' => $this->text()->notNull(),
            // Additional Settings
            'opt_in' => $this->boolean()->defaultValue(0),
            'opt_in_field' => $this->text(),
            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_constant_contact_field}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'form_field' => $this->text(), // Easy Forms Form Field
            'list_field' => $this->text(), // ConstantContact Subscriber List Field
        ], $tableOptions);
    }

    public function safeDown()
    {
        $this->dropTable('{{%addon_constant_contact_field}}');
        $this->dropTable('{{%addon_constant_contact}}');
    }
}
