<?php

use app\helpers\SubmissionHelper;
use app\themes\next\bundles\WysiwygBundle;
use yii\helpers\Html;
use yii\helpers\Url;
use kartik\form\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\conditional_email\models\ConditionalEmailTemplate */
/* @var $form yii\widgets\ActiveForm */

WysiwygBundle::register($this);

// Load autocomplete library
$this->registerJsFile('@web/static_files/js/libs/jquery.textcomplete.min.js', ['depends' => WysiwygBundle::class]);

/*
 * Data for Autocomplete
 */
$fields = SubmissionHelper::getFieldsForFieldMapping();
$fieldList = [];
foreach ($fields as $name => $label) {
    array_push($fieldList, [
        "text" => $label,
        "value" => $name
    ]);
}

// PHP options required by form.settings.js
$options = array(
    "fieldList" => $fieldList,
    "fieldListUrl" => Url::to(['/ajax/field-list']),
);

// Pass php options to javascript
$this->registerJs("var options = ".json_encode($options).";", $this::POS_BEGIN, 'pdf-editor-options');

?>

<div class="conditional-email-template-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'name')->textInput([
                'placeholder' => Yii::t('app', "Enter the template name..."),
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'body_html')->textarea(array(
                'rows'=>6,
                'placeholder'=>Yii::t('app', 'Enter the email body in html format...'),
            )); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'body_text')->textarea(array(
                'rows'=>6,
                'placeholder'=>Yii::t('app', 'Enter the email body in plain text...'),
                'class' => 'form-control placeholder-autocomplete',
            )); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="form-group">
                <?= Html::submitButton($model->isNewRecord ?
                    Yii::t('app', 'Save') :
                    Yii::t('app', 'Update'), ['class' => 'btn btn-primary']) ?>
            </div>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<?php

$enableLinkText = Yii::t('app', 'Rich-Text Editor');
$disableLinkText = Yii::t('app', 'HTML Code');

$script = <<<JS

    $(document).ready(function() {
        /**
         * Show Wysiwyg editor
         */
        if (typeof tinymce !== 'undefined') {
            var tinymceOptions = {
                selector: '#conditionalemailtemplate-body_html',
                height: 500,
                valid_elements: '*[*]',
                entity_encoding: "raw",
                plugins: 'advlist autolink link image lists charmap print preview hr anchor ' +
                    'searchreplace wordcount visualblocks visualchars code fullscreen fullpage insertdatetime nonbreaking ' +
                    'table directionality paste',
                toolbar: 'undo redo | styleselect | bold italic forecolor backcolor | alignleft aligncenter alignright alignjustify | ltr rtl | bullist numlist outdent indent | hr link image table | preview fullscreen code',
                convert_urls: false,
                setup: function (editor) {
                    editor.ui.registry.addAutocompleter('field-list', {
                        ch: '{',
                        minChars: 0,
                        columns: 1,
                        fetch: function (pattern) {
                            var matchedChars = options.fieldList.filter(function (character) {
                                return character.text.indexOf(pattern) !== -1;
                            });
    
                            return new tinymce.util.Promise(function (resolve) {
                                var results = matchedChars.map(function (character) {
                                    return {
                                        value: "{{ " + character.value + " }} ",
                                        text: character.text,
                                        icon: character.value
                                    }
                                });
                                resolve(results);
                            });
                        },
                        onAction: function (autocompleteApi, rng, value) {
                            editor.selection.setRng(rng);
                            editor.insertContent(value);
                            autocompleteApi.hide();
                        }
                    });
                }
            };
            if ($('body').attr('data-bs-theme') === 'dark') {
                tinymceOptions.skin = 'oxide-dark';
                tinymceOptions.content_css = 'dark';
            }
            tinymce.init(tinymceOptions);
            
            $("#conditionalemailtemplate-body_html").on('input', function() {
                tinymce.get("conditionalemailtemplate-body_html").setContent($(this).val());
            });
            
            var editorLink = $("<a />", {
                id : "enableLink",
                name : "enableLink",
                href : "javascript;",
                text : "{$disableLinkText}"
            }).click(function (e) {
                e.preventDefault();
                $(".tox").toggle();
                $("#conditionalemailtemplate-body_html").toggle();
                $(this).text(function(i, text){
                    if (text === "{$disableLinkText}") {
                        // tinymce.activeEditor.mode.set("readonly");
                        return "{$enableLinkText}";
                    }
                    // tinymce.activeEditor.mode.set("design");
                    return "{$disableLinkText}"
                });
            });
            
            $("<span class='pull-right' />").append(editorLink).insertBefore("#conditionalemailtemplate-body_html");
        }
        
        /**
         * Autocomplete
         */
        $('body').on('click', '.placeholder-autocomplete', function (e) {
            // Add autocomplete suggestions to text format
            var currentTarget = $(e.currentTarget);
            currentTarget
                .textcomplete('destroy');
            currentTarget
                .textcomplete([
                    {
                        match: function () {
                            return /(\.*){(\w*)$/;
                        },
                        search: function (term, callback, match) {
                            $.post(options.fieldListUrl, {
                                term: typeof match[2] === "undefined" ? '' : match[2],
                                _csrf: $('meta[name=csrf-token]').attr('content')
                            })
                                .done(function(response) {
                                    if (typeof response.data === "object") {
                                        var data = Object.keys(response.data).map(function(key) {
                                            var val = {};
                                            val[key] = "<span>" + key + "</span>" + response.data[key];
                                            return val;
                                        });
                                        callback($.map(data, function (f) {
                                            var value = f[Object.keys(f)[0]];
                                            return value.indexOf(term) === 0 ? f : null;
                                        }));
                                    } else {
                                        callback([]);
                                    }
                                });
                        },
                        template: function (f) {
                            return f[Object.keys(f)[0]];
                        },
                        index: 1,
                        replace: function (f) {
                            var key = Object.keys(f)[0];
                            return '{{ ' + key + ' }} ';
                        }
                    }
                ], {
                    zIndex: 1500,
                    maxCount: -1
                });
        });
    });

JS;

$this->registerJs($script, $this::POS_END);
