<?php

use app\components\widgets\ConditionsBuilder;
use dosamigos\selectize\SelectizeDropDownList;
use kartik\depdrop\DepDrop;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use yii\helpers\Html;
use yii\helpers\Url;
use kartik\form\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\conditional_email\models\ConditionalEmail */
/* @var $form \yii\widgets\ActiveForm */
/* @var $forms array [id => name] of Form models */
/* @var $templates array [id => name] of Form models */

$model->status = $model->isNewRecord ? 1 : $model->status;


/*
 * Emails
 */
$emails = ['' => '']; // Allow empty value to display placeholder

// Add email fields
if (isset($model->form->formData)) {
    $emailLabels = $model->form->formData->getEmailLabels();

    $emailFields = array(
        Yii::t('app', 'Email Fields') => $emailLabels,
    );

    // If the form has email fields, add to config form
    if (sizeof($emailLabels) > 0) {
        $emails = array_merge($emails, $emailFields);
    }
}

// Add email address
if (!$model->isNewRecord) {
    if (!empty($model->mail_reply_to)) {
        // Remove all illegal characters from email
        $email = filter_var($model->mail_reply_to, FILTER_SANITIZE_EMAIL);
        // Validate e-mail
        if (!filter_var($email, FILTER_VALIDATE_EMAIL) === false) {
            $emails = array_merge($emails, array(
                Yii::t('app', 'Emails') => [$email => $email],
            ));
        }
    }
}

?>

<div class="conditional-email-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'name')->textInput([
                'placeholder' => Yii::t('app', "Enter the condition name..."),
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'form_id')->widget(Select2::class, [
                'data' => $forms,
                'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(Yii::t('app', 'Form')); ?>
        </div>
        <div class="col-sm-6">
            <?= $form->field($model, 'event')->widget(Select2::class, [
                'data' => \app\helpers\EventHelper::supportedFormEvents(['addons' => true]),
            ]); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= ConditionsBuilder::widget([
                'label' => Yii::t('app', 'Conditions'),
            ]) ?>
            <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'mail_subject')->textInput([
                'placeholder' => Yii::t('app', 'Enter subject...'),
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-6">
            <?= $form->field($model, 'template_id')->widget(Select2::class, [
                'data' => $templates,
                'options' => ['placeholder' => Yii::t('app', 'Select an email template...')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(Yii::t('app', 'Body (Template)')); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'mail_to')->textInput([
                'placeholder' => Yii::t('app', "Enter e-mail address..."),
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'mail_cc')->textInput([
                'placeholder' => Yii::t('app', "Enter e-mail address..."),
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'mail_bcc')->textInput([
                'placeholder' => Yii::t('app', "Enter e-mail address..."),
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'mail_reply_to')->widget(SelectizeDropDownList::class, [
                'items' => $emails,
                'options' => [
                    'placeholder' => Yii::t('app', "Enter e-mail or select a field..."),
                ],
                'clientOptions' => [
                    'create' => true,
                    'sortField' => 'text',
                ]
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <?= Html::hiddenInput('field_to', $model->field_to, ['id'=>'field_to']) ?>
            <?= $form->field($model, 'field_to')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['conditionalemail-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => Url::to(['/addons/conditional_email/admin/email-fields']),
                    'initialize' => !$model->isNewRecord,
                    'params'=>['field_to'],
                ]
            ])->hint(Yii::t('app', 'Your form must have an email field.')) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'mail_from_name')->textInput([
                'placeholder' => Yii::t('app', "Enter your name or company..."),
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-6">
            <?= $form->field($model, 'status')->widget(SwitchInput::class, [
                'pluginOptions' => [
                    'onColor' => 'primary',
                ],
            ]) ?>
        </div>
    </div>

    <div class="row mt-2">
        <div class="col-sm-6">
            <div class="form-group">
                <?= $form->field($model, 'mail_receipt_copy')->checkbox(array(
                    'custom' => true,
                )); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <div class="form-group">
                <?= $form->field($model, 'mail_attachments')->checkbox(array(
                    'custom' => true,
                )); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="form-group" style="margin-top: 20px">
                <?= Html::submitButton($model->isNewRecord ?
                    Yii::t('app', 'Save') :
                    Yii::t('app', 'Update'), ['class' => 'btn btn-primary']) ?>
            </div>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<?php

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int) !$model->isNewRecord;

$script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#conditionalemail-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['conditionalemail-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

$this->registerJs($script, $this::POS_END, 'conditional_email');
