<?php

namespace app\modules\addons\modules\conditional_email\models;

use app\components\User;
use app\helpers\ArrayHelper;
use app\modules\addons\modules\conditional_email\Module;
use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\modules\addons\modules\conditional_email\models\ConditionalEmailTemplate;

/**
 * ConditionalEmailTemplateSearch represents the model behind the search form of `app\modules\addons\modules\conditional_email\models\ConditionalEmailTemplate`.
 */
class ConditionalEmailTemplateSearch extends ConditionalEmailTemplate
{

    public $author;
    public $lastEditor;

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'created_by', 'updated_by'], 'integer'],
            [['name', 'body_html', 'body_text', 'author', 'lastEditor', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ConditionalEmailTemplate::find();

        $query->joinWith(['author a', 'lastEditor le']);
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => Yii::$app->user->preferences->get('GridView.pagination.pageSize'),
            ],
            'sort' => [
                'defaultOrder' => [
                    'updated_at' => SORT_DESC,
                ]
            ],
        ]);

        $users = \Da\User\Model\User::find()->where(['subscription_id' => Yii::$app->user->identity->subscription_id])->all();
        $allSubscriptionUserIds = ArrayHelper::getColumn($users, 'id');
        $query->andFilterWhere(['in', '{{%addon_conditional_email_template}}.created_by', $allSubscriptionUserIds]);

        $dataProvider->sort->attributes['a'] = [
            'asc' => ['{{%user}}.username' => SORT_ASC],
            'desc' => ['{{%user}}.username' => SORT_DESC],
        ];

        $dataProvider->sort->attributes['le'] = [
            'asc' => ['{{%user}}.username' => SORT_ASC],
            'desc' => ['{{%user}}.username' => SORT_DESC],
        ];

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        if (isset($this->updated_at) && !empty($this->updated_at)) {
            list($start, $end) = explode(" - ", $this->updated_at);
            $startAt = strtotime(trim($start));
            // Add +1 day to the endAt
            $endAt = strtotime(trim($end)) + (24 * 60 * 60);
            $query->andFilterWhere(['between', '{{%addon_conditional_email_template}}.updated_at', $startAt, $endAt]);
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
        ]);

        $query->andFilterWhere(['like', 'name', $this->name])
            ->andFilterWhere(['like', 'a.username', $this->author])
            ->andFilterWhere(['like', 'le.username', $this->lastEditor]);

        /** @var User $currentUser */
        $currentUser = Yii::$app->user;

        // If current user can see all forms, return data provider
        if ($currentUser->can("viewForms")) {
            return $dataProvider;
        }

        $ids = [];

        $pdfModule = Module::getInstance();
        if ($pdfModule) {
            $pdfTemplates = $pdfModule->getCurrentUserEmailTemplates()->asArray()->all();
            $ids = ArrayHelper::getColumn($pdfTemplates, 'id');
        }

        // Important restriction. If empty, don't show any configuration
        $ids = count($ids) > 0 ? $ids : 0;
        $query->andFilterWhere(['{{%addon_conditional_email_template}}.id' => $ids]);

        return $dataProvider;
    }
}
