<?php

namespace app\modules\addons\modules\conditional_email\models;

use app\components\behaviors\DateTrait;
use app\models\User;
use Yii;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;
use yii\helpers\HtmlPurifier;

/**
 * This is the model class for table "{{%addon_conditional_email_template}}".
 *
 * @property int $id
 * @property string $name
 * @property string $body_html
 * @property string $body_text
 * @property int $created_by
 * @property int $updated_by
 * @property int $created_at
 * @property int $updated_at
 * @property User $author
 * @property User $lastEditor
 */
class ConditionalEmailTemplate extends \yii\db\ActiveRecord
{
    use DateTrait;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%addon_conditional_email_template}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'body_html', 'body_text'], 'string'],
            [['name', 'body_html'], 'required'],
            [['created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
            [['body_html'], 'filter', 'filter' => function ($value) {
                // Allows sending custom emails
                if (strpos($value, "</html>") !== false) {
                    return $value;
                }
                return HtmlPurifier::process($value);
            }],
            [['body_text'], 'filter', 'filter' => function ($value) { return strip_tags($value); }],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'name' => Yii::t('app', 'Name'),
            'body_html' => Yii::t('app', 'Email Body'),
            'body_text' => Yii::t('app', 'Body Text'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }
}
