<?php

namespace app\modules\addons\modules\conditional_email\models;

use app\components\behaviors\DateTrait;
use app\components\validators\MultipleEmailValidator;
use app\models\FormSubmission;
use app\models\User;
use Yii;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;
use app\models\Form;

/**
 * This is the model class for table "{{%addon_conditional_email}}".
 *
 * @property int $id
 * @property int $form_id
 * @property int $status
 * @property string $name
 * @property string $conditions
 * @property integer $action
 * @property integer $event
 * @property string $template_id
 * @property string $field_to
 * @property string $mail_to
 * @property string $mail_reply_to
 * @property string $mail_from_name
 * @property string $mail_cc
 * @property string $mail_bcc
 * @property string $mail_subject
 * @property int $mail_text_only
 * @property int $mail_receipt_copy
 * @property int $mail_attachments
 * @property int $created_by
 * @property int $updated_by
 * @property int $created_at
 * @property int $updated_at
 *
 * @property Form $form
 * @property ConditionalEmailTemplate $template
 * @property User $author
 * @property User $lastEditor
 */
class ConditionalEmail extends \yii\db\ActiveRecord
{
    use DateTrait;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%addon_conditional_email}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['form_id', 'name', 'template_id'], 'required'],
            [['form_id', 'status', 'action', 'event', 'mail_text_only', 'mail_receipt_copy', 'mail_attachments', 'created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
            [['field_to', 'mail_to', 'mail_cc', 'mail_bcc', 'mail_reply_to', 'mail_from_name', 'mail_subject'], 'string', 'max' => 255],
            [['mail_to', 'mail_cc', 'mail_bcc'], MultipleEmailValidator::class],
            [['conditions'], 'string']
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form'),
            'status' => Yii::t('app', 'Status'),
            'name' => Yii::t('app', 'Name'),
            'conditions' => Yii::t('app', 'Conditions'),
            'action' => Yii::t('app', 'Action'),
            'event' => Yii::t('app', 'Event'),
            'template_id' => Yii::t('app', 'Body (Template)'),
            'field_to' => Yii::t('app', 'Send To Field'),
            'mail_to' => Yii::t('app', 'Send To'),
            'mail_reply_to' => Yii::t('app', 'Reply To'),
            'mail_from_name' => Yii::t('app', 'Sender Name'),
            'mail_cc' => Yii::t('app', 'CC'),
            'mail_bcc' => Yii::t('app', 'BCC'),
            'mail_subject' => Yii::t('app', 'Subject'),
            'mail_text_only' => Yii::t('app', 'Text Only'),
            'mail_receipt_copy' => Yii::t('app', 'Includes a Submission Copy'),
            'mail_attachments' => Yii::t('app', 'Attach Form Files'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTemplate()
    {
        return $this->hasOne(ConditionalEmailTemplate::class, ['id' => 'template_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }

    /**
     * @return bool
     */
    public function mailReplyToIsEmail()
    {
        $email = $this->mail_reply_to;
        // Remove all illegal characters from email
        $email = filter_var($email, FILTER_SANITIZE_EMAIL);
        // Validate e-mail
        if (!filter_var($email, FILTER_VALIDATE_EMAIL) === false) {
            return true;
        }
        return false;
    }
}
