<?php

use yii\db\Migration;

/**
 * Class m191214_050029_upgrade_to_110
 */
class m191214_050029_upgrade_to_110 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Remove opt-in fields
        $this->dropColumn('{{%addon_conditional_email}}', 'form_field_value');
        $this->dropColumn('{{%addon_conditional_email}}', 'form_field_id');

        // Add Conditional logic fields
        $this->addColumn('{{%addon_conditional_email}}', 'name', $this->text()->notNull()->after('status'));
        $this->addColumn('{{%addon_conditional_email}}', 'conditions', $this->text()->after('name'));
        $this->addColumn('{{%addon_conditional_email}}', 'action', $this->integer(1)->notNull()->defaultValue(0)->after('conditions'));
        $this->addColumn('{{%addon_conditional_email}}', 'event', $this->integer()->notNull()->defaultValue(1)->after('action'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_conditional_email}}', 'event');
        $this->dropColumn('{{%addon_conditional_email}}', 'action');
        $this->dropColumn('{{%addon_conditional_email}}', 'conditions');
        $this->dropColumn('{{%addon_conditional_email}}', 'name');

        $this->addColumn('{{%addon_conditional_email}}', 'form_field_id', $this->text()->after('status'));
        $this->addColumn('{{%addon_conditional_email}}', 'form_field_value', $this->text()->after('form_field_id'));
    }

}
