<?php

use yii\db\Migration;

/**
 * Class m190421_153831_init_addon_conditional_email
 */
class m190421_153831_init_addon_conditional_email extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_conditional_email}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(0),

            // Condition Settings
            'form_field_id' => $this->text(), // Checkbox ID
            'form_field_value' => $this->text(), // Expected value
            'template_id' => $this->text(),

            // Email Settings
            'field_to' => $this->text(), // Form Field ID
            'mail_to' => $this->text(), // Required
            'mail_reply_to' => $this->text(),
            'mail_from_name' => $this->text(),
            'mail_cc' => $this->text(),
            'mail_bcc' => $this->text(),
            'mail_subject' => $this->text(),
            'mail_text_only' => $this->boolean()->notNull()->defaultValue(0),
            'mail_receipt_copy' => $this->boolean()->notNull()->defaultValue(0),
            'mail_attachments' => $this->boolean()->notNull()->defaultValue(0),

            // Additional Settings
            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),

        ], $tableOptions);

        $this->createTable('{{%addon_conditional_email_template}}', [
            'id' => $this->primaryKey(),
            'name' => $this->text(),

            // Body Settings
            'body_html' => $this->text(),
            'body_text' => $this->text(),

            // Additional Settings
            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%addon_conditional_email_template}}');
        $this->dropTable('{{%addon_conditional_email}}');
    }

}
