<?php

namespace app\modules\addons\modules\cleverreach\models;

use Yii;

/**
 * This is the model class for table "{{%addon_cleverreach_item}}".
 *
 * @property integer $id
 * @property integer $cleverreach_id
 * @property integer $form_id
 * @property string $form_field
 * @property string $list_field
 */
class CleverReachField extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_cleverreach_field}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['cleverreach_id', 'form_id'], 'integer'],
            [['form_field', 'list_field'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'cleverreach_id' => Yii::t('app', 'CleverReach ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'form_field' => Yii::t('app', 'Form Field'),
            'list_field' => Yii::t('app', 'List Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCleverReach()
    {
        return $this->hasOne(CleverReach::class,['id'=>'cleverreach_id']);
    }
}
