<?php

namespace app\modules\addons\modules\cleverreach\models;

use app\components\behaviors\DateTrait;
use Yii;
use app\models\Form;
use app\models\User;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;
use app\components\behaviors\RelationTrait;

/**
 * This is the model class for table "{{%addon_cleverreach}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property integer $status
 * @property string $client_id
 * @property string $client_secret
 * @property string $oauth
 * @property string $name
 * @property string $conditions
 * @property integer $event
 * @property string $contact_list
 * @property string $subscriber_email
 * @property string $subscriber_status
 * @property string $subscriber_doi_form
 * @property string $subscriber_tags
 * @property integer $created_by
 * @property integer $updated_by
 * @property integer $created_at
 * @property integer $updated_at
 *
 * @property Form $form
 * @property CleverReachField[] $items
 * @property User $author
 * @property User $lastEditor
 */
class CleverReach extends \yii\db\ActiveRecord
{
    use RelationTrait, DateTrait;

    const ON = 1;
    const OFF = 0;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_cleverreach}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            [
                'class' => BlameableBehavior::class,
                'defaultValue' => function() {
                    return $this->owner->created_by;
                },
            ],
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'client_id', 'client_secret', 'oauth', 'name', 'contact_list', 'subscriber_email'], 'required'],
            [['form_id', 'status', 'event', 'created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
            [['client_id', 'client_secret', 'oauth', 'name', 'conditions', 'subscriber_status', 'subscriber_email', 'subscriber_doi_form', 'subscriber_tags'], 'string'],
            [['subscriber_doi_form'], 'required', 'when' => function ($model) {
                return $model->subscriber_status === 'inactive';
            }, 'whenClient' => "function (attribute, value) {
                return $(\"#cleverreach-subscriber_status\").val() === 'inactive';
            }"],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'status' => Yii::t('app', 'Status'),
            'client_id' => Yii::t('app', 'Client ID'),
            'client_secret' => Yii::t('app', 'Client Secret'),
            'oauth' => Yii::t('app', 'OAuth'),
            'name' => Yii::t('app', 'Name'),
            'conditions' => Yii::t('app', 'Conditions'),
            'event' => Yii::t('app', 'Event'),
            'contact_list' => Yii::t('app', 'Contact List'),
            'subscriber_status' => Yii::t('app', 'Status'),
            'subscriber_email' => Yii::t('app', 'Email'),
            'subscriber_doi_form' => Yii::t('app', 'DOI Form'),
            'subscriber_tags' => Yii::t('app', 'Tags'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getItems()
    {
        return $this->hasMany(CleverReachField::class, ['cleverreach_id' => 'id']);
    }

    public function setItems($value)
    {
        $this->loadRelated('items', $value);
    }

    /**
     * @inheritdoc
     */
    public function afterFind()
    {
        $this->contact_list = explode(',', $this->contact_list);

        parent::afterFind();
    }

    /**
     * @inheritdoc
     */
    public function beforeValidate()
    {
        if (is_array($this->contact_list)) {
            $this->contact_list = implode(',', $this->contact_list);
        }

        return parent::beforeValidate();
    }

    /**
     * @inheritdoc
     */
    public function beforeDelete()
    {
        if (parent::beforeDelete()) {
            CleverReachField::deleteAll(["cleverreach_id" => $this->id]);
            return true;
        } else {
            return false;
        }
    }
}
