<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

use yii\db\Migration;

class m170320_123234_init_addon_cleverreach extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_cleverreach}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(0),

            // Authorization
            'client_id' => $this->text()->notNull(),
            'client_secret' => $this->text()->notNull(),
            'oauth' => $this->text()->notNull(),
            // List Information
            'contact_list' => $this->text()->notNull(),
            // Subscriber Fields
            'subscriber_email' => $this->text()->notNull(),
            'subscriber_status' => $this->text(),
            'subscriber_doi_form' => $this->text(),
            'subscriber_tags' => $this->text(),
            // Settings
            'opt_in' => $this->boolean()->defaultValue(0),
            'opt_in_field' => $this->text(),

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_cleverreach_field}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'form_field' => $this->text(),
            'list_field' => $this->text(),
        ], $tableOptions);
    }

    public function safeDown()
    {
        $this->dropTable('{{%addon_cleverreach_field}}');
        $this->dropTable('{{%addon_cleverreach}}');
    }
}
