<?php

use app\components\widgets\ConditionsBuilder;
use yii\helpers\Html;
use yii\helpers\Url;
use kartik\form\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $form kartik\form\ActiveForm */
/* @var $model app\modules\addons\modules\campaign_monitor\models\CampaignMonitor */
/* @var $fieldModel app\modules\addons\modules\campaign_monitor\models\CampaignMonitorField */
/* @var $forms array [id => name] of Form models */
/* @var $lists array [id => name] of CampaignMonitor Subscriber Lists */
/* @var $connected boolean The connection to CampaignMonitor have beed stablished */

$this->title = Yii::t('app', 'Update Sign Up Form');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Campaign Monitor'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$formFieldUrl = Url::to(['/addons/campaign_monitor/admin/fields']);
$listFieldUrl = Url::to(['/addons/campaign_monitor/admin/campaign-monitor-fields']);

?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
            </div>
        </div>
    </div>
</div>
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <h2 class="page-title">
                    <?= Html::encode($this->title) ?>
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Html::encode($this->title) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin(); ?>
                        <div class="row">
                            <div class="col-sm-12">
                                <?= $form->field($model, 'api_key')->textInput([
                                    'maxlength' => true,
                                ]) ?>
                            </div>
                        </div>
                        <?php if (!empty($model->api_key)): ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <?= $form->field($model, 'name')->textInput([
                                        'placeholder' => Yii::t('app', "Enter a configuration name..."),
                                        'maxlength' => true,
                                    ]) ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= $form->field($model, 'form_id')->widget(Select2::class, [
                                        'data' => $forms,
                                        'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                                        'pluginOptions' => [
                                            'allowClear' => true
                                        ],
                                    ])->label(Yii::t('app', 'Form')); ?>
                                </div>
                                <div class="col-sm-6">
                                    <?= $form->field($model, 'list_id')->widget(Select2::class, [
                                        'data' => $lists,
                                        'options' => ['placeholder' => Yii::t('app', 'Select a list...')],
                                        'pluginOptions' => [
                                            'allowClear' => true
                                        ],
                                        'pluginEvents' => [
                                            "select2:select" => "function(event) {
                                $('#campaignmonitor-list_name').val($(event.currentTarget).find('option:selected').text());
                            }",
                                        ],
                                    ])->hint(Yii::t(
                                        'app',
                                        'Select the list in which you want to add subscribers.'
                                    )); ?>
                                    <?= $form->field($model, 'list_name')->hiddenInput()->label(false) ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-3">
                                    <?= $form->field($model, 'status')->widget(SwitchInput::class)->hint(Yii::t(
                                        'app',
                                        'Disables the integration at any time.'
                                    )) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($model, 'restart_subscription')->widget(SwitchInput::class)->hint( Yii::t(
                                        'app',
                                        'Only affects resubscribing subscribers.'
                                    )) ?>
                                </div>
                                <div class="col-sm-6">
                                    <?= $form->field($model, 'event')->widget(Select2::class, [
                                        'data' => \app\helpers\EventHelper::supportedFormEvents(),
                                    ]); ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <?= ConditionsBuilder::widget([
                                        'label' => Yii::t('app', 'Conditions'),
                                    ]) ?>
                                    <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <legend><?= Yii::t('app', 'Field Mapping') ?></legend>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= Html::hiddenInput('subscriber-email', $model->subscriber_email, ['id'=>'subscriber-email']) ?>
                                    <?= $form->field($model, 'subscriber_email')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['campaignmonitor-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $formFieldUrl,
                                            'params' => ['subscriber-email']
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-6">
                                    <?= Html::hiddenInput('subscriber-name', $model->subscriber_name, ['id'=>'subscriber-name']) ?>
                                    <?= $form->field($model, 'subscriber_name')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['campaignmonitor-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => $formFieldUrl,
                                            'params' => ['subscriber-name']
                                        ]
                                    ]) ?>
                                </div>
                            </div>

                            <?php foreach($model->items as $i => $item): ?>
                                <fieldset class="item">
                                    <div class="row">
                                        <div class="col-sm-5">
                                            <?= Html::hiddenInput('item-'.$i.'-form_field', $item->form_field, ['id'=>'item-'.$i.'-form_field']) ?>
                                            <?= $form->field($fieldModel, '['.$i.']form_field')->widget(DepDrop::class, [
                                                'pluginOptions' => [
                                                    'depends' => ['campaignmonitor-form_id'],
                                                    'placeholder' => Yii::t('app', 'Select...'),
                                                    'url' => $formFieldUrl,
                                                    'params' => ['item-'.$i.'-form_field']
                                                ]
                                            ]) ?>
                                        </div>
                                        <div class="col-sm-1" style="padding-top: 25px">
                                            <div class="text-primary" style="font-size: 22px; padding: 5px 18px 4px 22px; line-height: 22px;">
                                                <i class="fas fa-arrow-right"></i>
                                            </div>
                                        </div>
                                        <div class="col-sm-5">
                                            <?= Html::hiddenInput('item-'.$i.'-list_field', $item->list_field, ['id'=>'item-'.$i.'-list_field']) ?>
                                            <?= $form->field($fieldModel, '['.$i.']list_field')->widget(DepDrop::class, [
                                                'pluginOptions' => [
                                                    'depends' => ['campaignmonitor-list_id'],
                                                    'placeholder' => Yii::t('app', 'Select...'),
                                                    'url' => $listFieldUrl,
                                                    'params' => ['item-'.$i.'-list_field']
                                                ]
                                            ]) ?>
                                        </div>
                                        <div class="col-sm-1">
                                            <div class="form-group" style="padding-top: 28px;">
                                                <button type="button" class="btn btn-default btn-icon btn-remove">
                                                    <i class="fas fa-minus"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </fieldset>
                            <?php endforeach; ?>

                            <fieldset id="itemTemplate" class="d-none">
                                <div class="row">
                                    <div class="col-sm-5">
                                        <?= Html::hiddenInput('item-form_field', '', ['id'=>'item-form_field']) ?>
                                        <?= $form->field($fieldModel, 'form_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['campaignmonitor-form_id'],
                                                'initialize' => true,
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $formFieldUrl,
                                                'params'=>['item-form_field'],
                                            ],
                                            'pluginEvents' => [
                                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                                            ],
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-1" style="padding-top: 25px">
                                        <div class="text-primary" style="font-size: 22px; padding: 5px 18px 4px 22px; line-height: 22px;">
                                            <i class="fas fa-arrow-right"></i>
                                        </div>
                                    </div>
                                    <div class="col-sm-5">
                                        <?= Html::hiddenInput('item-list_field', '', ['id'=>'item-list_field']) ?>
                                        <?= $form->field($fieldModel, 'list_field')->widget(DepDrop::class, [
                                            'pluginOptions' => [
                                                'depends' => ['campaignmonitor-list_id'],
                                                'initialize' => true,
                                                'placeholder' => Yii::t('app', 'Select...'),
                                                'url' => $listFieldUrl,
                                                'params'=>['item-list_field'],
                                            ],
                                            'pluginEvents' => [
                                                "depdrop:afterChange" => "function(event, id, value) { 
                                                    $(event.currentTarget).attr('disabled', true)
                                                }",
                                            ],
                                        ]) ?>
                                    </div>
                                    <div class="col-sm-1">
                                        <div class="form-group" style="padding-top: 28px;">
                                            <button type="button" class="btn btn-default btn-icon btn-remove">
                                                <i class="fas fa-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>

                        <?php  endif; ?>

                        <div class="form-group" style="margin-top: 15px">
                            <?= Html::submitButton(
                                ' <i class="fas fa-check"></i> ' . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
                        </div>
                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php

$this->registerCss("legend { margin-top: 20px; }");

/**
 * Conditional Logic
 */

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int)!$model->isNewRecord;

$script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#campaignmonitor-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['campaignmonitor-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

$this->registerJs($script, $this::POS_END, 'campaign_monitor-conditions');

/**
 * Field Mapping
 */

$script = <<<JS

$(window).on('load', function() {
    $('#campaignmonitor-form_id').trigger('depdrop.change');
    $('#campaignmonitor-list_id').trigger('depdrop.change');
});

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="CampaignMonitorField[form_field]"]')
                    .attr('name', 'CampaignMonitorField[' + item + '][form_field]')
                    .attr('id', 'campaignmonitorfield-' + item + '-form_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['campaignmonitor-form_id'],
                        url: '$formFieldUrl'
                    })
                    .end()
                .find('[name="CampaignMonitorField[list_field]"]')
                    .attr('name', 'CampaignMonitorField[' + item + '][list_field]')
                    .attr('id', 'campaignmonitorfield-' + item + '-list_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['campaignmonitor-list_id'],
                        url: '$listFieldUrl'
                    })
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

$this->registerJs($script, $this::POS_END, 'campaign_monitor');

?>