<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.1
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\campaign_monitor\services;

use Yii;
use Exception;

class CampaignMonitorService
{
    public $auth;
    public $clientID;

    public function __construct($apiKey)
    {
        spl_autoload_register(function(){
            require_once(Yii::getAlias('@addons/campaign_monitor/campaign_monitor_api/csrest_general.php'));
        });

        $this->auth = ['api_key' => $apiKey];
        $this->clientID = $this->getClientID();
    }

    public function getClientID()
    {
        $wrap = new \CS_REST_General($this->auth);

        $result = $wrap->get_clients();

        if ($result->was_successful()) {
            if (count($result->response) > 1) {
                throw new Exception('Please enter a valid Client API key and not the Administrator API key.');
            } elseif (isset($result->response, $result->response[0], $result->response[0]->ClientID)) {
                return $result->response[0]->ClientID; // return Client ID
            }
        }

        throw new Exception('Error getting the Client ID.');
    }

    public function wrapper()
    {
        spl_autoload_register(function(){
            require_once(Yii::getAlias('@addons/campaign_monitor/campaign_monitor_api/csrest_clients.php'));
        });

        $wrap = new \CS_REST_Clients($this->clientID, $this->auth);

        return $wrap;
    }

    public function getSubscriberLists()
    {
        $result = $this->wrapper()->get_lists();
        $lists = [];

        if ($result->was_successful() && count($result->response) > 0) {
            foreach ($result->response as $list) {
                $lists[$list->ListID] = $list->Name;
            }
        }

        return $lists;
    }

    public function getCustomFields($listID)
    {
        spl_autoload_register(function() {
            require_once(Yii::getAlias('@addons/campaign_monitor/campaign_monitor_api/csrest_lists.php'));
        });

        $fields = [];
        $wrap = new \CS_REST_Lists($listID, $this->auth);
        $result = $wrap->get_custom_fields();
        if ($result->was_successful() && count($result->response) > 0) {
            foreach($result->response as $customField ) {
                array_push($fields, [
                    'id' => $customField->Key,
                    'name' => $customField->FieldName,
                ]);
            }
        }

        return $fields;
    }

    public function addSubscriber($listID, $params)
    {
        spl_autoload_register(function() {
            require_once(Yii::getAlias('@addons/campaign_monitor/campaign_monitor_api/csrest_subscribers.php'));
        });

        $wrap = new \CS_REST_Subscribers($listID, $this->auth);
        $result = $wrap->add($params);

        if (!$result->was_successful()) {
            Yii::error('Error Code: '. $result->response->Code . '. ' . $result->response->Message, 'campaign_monitor');
            throw new Exception($result->response->Message, $result->response->Code);
        }

        return $result;
    }
}