<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\campaign_monitor\models;

use Yii;

/**
 * This is the model class for table "addon_campaign_monitor_field".
 *
 * @property integer $id
 * @property integer $campaign_monitor_id
 * @property integer $form_id
 * @property string $form_field
 * @property string $list_field
 */
class CampaignMonitorField extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'addon_campaign_monitor_field';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['campaign_monitor_id', 'form_id'], 'integer'],
            [['form_field', 'list_field'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'campaign_monitor_id' => Yii::t('app', 'Campaign Monitor ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'form_field' => Yii::t('app', 'Form Field'),
            'list_field' => Yii::t('app', 'List Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCampaignMonitor()
    {
        return $this->hasOne(CampaignMonitor::class,['id'=>'campaign_monitor_id']);
    }
}