<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\campaign_monitor\models;

use app\components\behaviors\DateTrait;
use Yii;
use app\models\Form;
use app\models\User;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;
use app\components\behaviors\RelationTrait;

/**
 * This is the model class for table "{{%addon_campaign_monitor}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property integer $status
 * @property string $api_key
 * @property string $client_id
 * @property string $consumer_key
 * @property string $consumer_secret
 * @property string $access_token
 * @property string $access_secret
 * @property string $name
 * @property string $conditions
 * @property integer $event
 * @property string $list_id
 * @property string $list_name
 * @property string $subscriber_email
 * @property string $subscriber_name
 * @property integer $restart_subscription
 * @property integer $created_by
 * @property integer $updated_by
 * @property integer $created_at
 * @property integer $updated_at
 *
 * @property Form $form
 * @property CampaignMonitorField[] $items
 * @property User $author
 * @property User $lastEditor
 */
class CampaignMonitor extends \yii\db\ActiveRecord
{
    use RelationTrait, DateTrait;

    const ON = 1;
    const OFF = 0;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_campaign_monitor}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'api_key', 'client_id', 'name', 'list_id', 'list_name', 'subscriber_email', 'subscriber_name'], 'required'],
            [['form_id', 'status', 'event', 'restart_subscription', 'created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
            [['name', 'conditions'], 'string'],
            [['api_key', 'client_id', 'list_id', 'list_name', 'subscriber_email', 'subscriber_name'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'status' => Yii::t('app', 'Status'),
            'api_key' => Yii::t('app', 'Api Key'),
            'client_id' => Yii::t('app', 'Client ID'),
            'name' => Yii::t('app', 'Name'),
            'conditions' => Yii::t('app', 'Conditions'),
            'event' => Yii::t('app', 'Event'),
            'list_id' => Yii::t('app', 'List ID'),
            'list_name' => Yii::t('app', 'List Name'),
            'subscriber_email' => Yii::t('app', 'Subscriber Email Address'),
            'subscriber_name' => Yii::t('app', 'Subscriber Name'),
            'restart_subscription' => Yii::t('app', 'Restart Subscription'),
            'created_by' => Yii::t('app', 'Created by'),
            'updated_by' => Yii::t('app', 'Updated by'),
            'created_at' => Yii::t('app', 'Created at'),
            'updated_at' => Yii::t('app', 'Updated at'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getItems()
    {
        return $this->hasMany(CampaignMonitorField::class, ['campaign_monitor_id' => 'id']);
    }

    public function setItems($value)
    {
        $this->loadRelated('items', $value);
    }

    /**
     * @inheritdoc
     */
    public function beforeDelete()
    {
        if (parent::beforeDelete()) {
            CampaignMonitorField::deleteAll(["campaign_monitor_id" => $this->id]);
            return true;
        } else {
            return false;
        }
    }
}