<?php

use yii\db\Migration;

/**
 * Class m200627_023312_update_to_1_3
 */
class m200627_023312_update_to_1_3 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Add Conditional logic fields
        $this->addColumn('{{%addon_campaign_monitor}}', 'name', $this->text()->notNull()->after('status'));
        $this->addColumn('{{%addon_campaign_monitor}}', 'event', $this->integer()->notNull()->defaultValue(1)->after('name'));
        $this->addColumn('{{%addon_campaign_monitor}}', 'conditions', $this->text()->after('event'));

        // Add foreign column to fields
        $this->addColumn('{{%addon_campaign_monitor_field}}', 'campaign_monitor_id', $this->integer(11)->notNull()->after('id'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_campaign_monitor_field}}', 'campaign_monitor_id');

        $this->dropColumn('{{%addon_campaign_monitor}}', 'event');
        $this->dropColumn('{{%addon_campaign_monitor}}', 'conditions');
        $this->dropColumn('{{%addon_campaign_monitor}}', 'name');
    }
}
