<?php

use yii\web\View;
use yii\helpers\Url;
use yii\helpers\Html;
use app\components\widgets\GridView;
use app\components\widgets\ActionBar;
use kartik\switchinput\SwitchInput;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */
/* @var $model app\modules\addons\modules\braintree\models\Braintree */
/* @var $searchModel app\modules\addons\modules\braintree\models\BraintreeSearch */

$this->title = Yii::t('app', 'Braintree Payments');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Braintree'), 'url' => ['index']];
$this->params['breadcrumbs'][] = Yii::t('app', 'Payments');


$gridColumns = [
    [
        'class' => '\kartik\grid\SerialColumn'
    ],
    [
        'class'=>'kartik\grid\ExpandRowColumn',
        'width'=>'50px',
        'value'=>function ($model, $key, $index, $column) {
            return GridView::ROW_COLLAPSED;
        },
        'detail'=>function ($model, $key, $index, $column) {
            return sprintf("<pre>%s</pre>", json_encode(json_decode($model->data), JSON_PRETTY_PRINT));
        },
        'headerOptions'=>['class'=>'kartik-sheet-style'],
        'expandOneOnly'=>true,
        'expandIcon' => '<span class="glyphicon glyphicon-expand"></span>',
        'collapseIcon' => '<span class="glyphicon glyphicon-collapse"></span>',
        'expandAllTitle' => Yii::t('app', 'API Response - Expand All'),
        'collapseAllTitle' => Yii::t('app', 'API Response - Collapse All'),
    ],
    [
        'attribute'=> 'submission',
        'label' => Yii::t('app', 'Submission'),
        'format' => 'raw',
        'value' => function ($model) {
            return isset($model->form_id, $model->submission_id) ?
                Html::a('#' . $model->submission_id, ['/form/submissions', 'id' => $model->form_id, '#' => 'view/'.$model->submission_id ]) :
                null;
        },
    ],
    'transaction',
];

$options = array(
    'currentPage' => Url::toRoute(['payments', 'id' => $model->id]), // Used by filters
);

// Pass php options to javascript
$this->registerJs("var options = ".json_encode($options).";", View::POS_BEGIN, 'form-options');

?>
<div class="braintree-payments">

    <div class="row">
        <div class="col-md-12">
            <?= GridView::widget([
                'id' => 'braintree-payments-grid',
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'columns' => $gridColumns,
                'resizableColumns' => false,
                'pjax' => false,
                'export' => false,
                'responsive' => true,
                'bordered' => false,
                'striped' => true,
                'panelTemplate' => '<div class="panel {type}">
                    {panelHeading}
                    {panelBefore}
                    {items}
                    <div style="text-align: center">{pager}</div>
                </div>',
                'panel' => [
                    'type'=>GridView::TYPE_INFO,
                    'heading'=> $model->form->name . ' <small class="panel-subtitle hidden-xs">'. Yii::t('app', 'Braintree Payments').'</small>',
                    'footer'=>false,
                    // Visible only for admin user
                    'before'=> (!empty(Yii::$app->user) && Yii::$app->user->can("admin")) ?
                        ActionBar::widget([
                            'grid' => 'braintree-grid',
                            'templates' => [
                                '{back}' => ['class' => 'col-xs-6 col-md-8'],
                                '{filters}' => ['class' => 'col-xs-6 col-md-4'],
                            ],
                            'elements' => [
                                'back' =>
                                    Html::a(
                                        '<span class="glyphicon glyphicon-arrow-left"></span> ' .
                                        Yii::t('app', 'Go Back'),
                                        ['index'],
                                        ['class' => 'btn btn-default']
                                    ),
                                'filters' => SwitchInput::widget(
                                    [
                                        'name'=>'filters',
                                        'type' => SwitchInput::CHECKBOX,
                                        'pluginOptions' => [
                                            'size' => 'mini',
                                            'animate' => false,
                                            'labelText' => Yii::t('app', 'Filter'),
                                        ],
                                        'pluginEvents' => [
                                            "switchChange.bootstrapSwitch" => "function(event, state) {
                                                if (state) {
                                                    $('.filters').fadeIn()
                                                    localStorage.setItem('gridView.filters', 1);
                                                } else {
                                                    $('.filters').fadeOut()
                                                    localStorage.setItem('gridView.filters', 0);
                                                    window.location = options.currentPage;
                                                }
                                            }",
                                        ],
                                        'containerOptions' => ['style' => 'margin-top: 6px; text-align: right'],
                                    ]
                                ),
                            ],
                        ]) : null,
                ],
                'toolbar' => false
            ]); ?>
        </div>
    </div>
</div>

<?php
$js = <<< 'SCRIPT'

$(function () {
    // Filters
    var state = localStorage.getItem('gridView.filters');
    if (typeof state !== undefined && state == 1) {
        $('input[name="filters"]').bootstrapSwitch('state', true);
    } else {
        $('input[name="filters"]').bootstrapSwitch('state', false);
    }
});

SCRIPT;
// Register tooltip/popover initialization javascript
$this->registerJs($js);