<?php

use app\components\widgets\ConditionsBuilder;
use yii\helpers\Html;
use yii\helpers\Url;
use kartik\form\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;
use app\modules\addons\modules\braintree\helpers\Locale;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\braintree\models\Braintree */
/* @var $itemModel app\modules\addons\modules\braintree\models\BraintreeItem */
/* @var $form yii\widgets\ActiveForm */
/* @var $forms array [id => name] of Form models */

$url = Url::to(['/addons/braintree/admin/fields']);

?>

<div class="braintree-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'name')->textInput([
                'placeholder' => Yii::t('app', "Enter a configuration name..."),
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'environment')->dropDownList(
                ['sandbox' => 'Sandbox', 'production' => 'Production']
            ) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'merchant_id')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'public_key')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'private_key')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row" style="margin-bottom: 10px;">
        <div class="col-sm-12">
            <span class="help-block">
                <span class="label label-default"><?= Yii::t('app', 'Note') ?></span>
                <?= Yii::t(
                    'app',
                    'Change the Merchant ID, Public Key and Secret Key according to the environment.'
                ) ?>
            </span>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'form_id')->widget(Select2::class, [
                'data' => $forms,
                'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(Yii::t('app', 'Form')); ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'event')->widget(Select2::class, [
                'data' => \app\helpers\EventHelper::supportedFormEventsInPostRequest(),
            ]); ?>
        </div>
        <div class="col-sm-3">
            <?php if ($model->isNewRecord) { $model->status = true; } ?>
            <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= ConditionsBuilder::widget([
                'label' => Yii::t('app', 'Conditions'),
            ]) ?>
            <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <legend><?= Yii::t('app', 'Items') ?></legend>
        </div>
    </div>
    
    <?php if ($model->isNewRecord): ?>

        <fieldset class="item">
            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($itemModel, '[0]description')->textInput([
                        'maxlength' => true,
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, '[0]api_name')->textInput([
                        'maxlength' => true,
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, '[0]price')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['braintree-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => Url::to(['/addons/braintree/admin/fields']),
                            'params'=>['braintree-item_1']
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, '[0]quantity')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['braintree-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => Url::to(['/addons/braintree/admin/fields']),
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 25px;">
                        <button type="button" class="btn btn-default btn-add">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                </div>
            </div>
        </fieldset>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($itemModel, 'description')->textInput([
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, 'api_name')->textInput([
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, 'price')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['braintree-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'quantity')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['braintree-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 25px;">
                        <button type="button" class="btn btn-default btn-remove">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </div>
        </fieldset>

    <?php else: ?>

        <?php foreach($model->items as $i => $item): ?>
            <fieldset class="item">
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($item, '['.$i.']description')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($item, '['.$i.']api_name')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('item-'.$i.'-price',
                            $item->price, ['id'=>'item-'.$i.'-price']) ?>
                        <?= $form->field($item, '['.$i.']price')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['braintree-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['item-'.$i.'-price'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('item-'.$i.'-quantity',
                            $item->quantity, ['id'=>'item-'.$i.'-quantity']) ?>
                        <?= $form->field($item, '['.$i.']quantity')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['braintree-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['item-'.$i.'-quantity'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-default btn-remove" style="margin-top: 25px;">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </fieldset>
        <?php endforeach; ?>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-3">
                    <?= $form->field($itemModel, 'description')->textInput([
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, 'api_name')->textInput([
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= Html::hiddenInput('item-price', '', ['id'=>'item-price']) ?>
                    <?= $form->field($itemModel, 'price')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['braintree-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                            'params'=>['item-price'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= Html::hiddenInput('item-quantity', '', ['id'=>'item-quantity']) ?>
                    <?= $form->field($itemModel, 'quantity')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['braintree-form_id'],
                            'initialize' => true,
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                            'params'=>['item-quantity'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <button type="button" class="btn btn-default btn-remove" style="margin-top: 25px;">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
        </fieldset>
    
    <?php endif; ?>

    <div class="row">
        <div class="col-sm-12">
            <span class="help-block">
                <span class="label label-default"><?= Yii::t('app', 'Note') ?></span>
                <?= Yii::t(
                    'app',
                    'Each item specify information about a product or service.'
                ) ?>
                <?= Yii::t(
                    'app',
                    'Price (required) and Quantity (optional) will be multiplied in order to get the item total value.'
                ) ?>
            </span>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <legend><?= Yii::t('app', 'Credit Card Field Settings') ?></legend>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <?php if ($model->isNewRecord) { $model->label = Yii::t('app', 'Credit or debit card'); } ?>
            <?= $form->field($model, 'label')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-sm-3">
            <?php if ($model->isNewRecord) { $model->locale = 'en_US'; } ?>
            <?= $form->field($model, 'locale')->dropDownList(
                Locale::all()
            ) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'cardholder_name')->widget(SwitchInput::classname(), [
                'pluginEvents' => [
                    "switchChange.bootstrapSwitch" => "function(event, state) {
                        if (state == true) {
                            $('#cardholder_name_required_field').show();
                        } else {
                            $('#cardholder_name_required_field').hide();
                        }
                    }",
                ],
            ]); ?>
        </div>
        <div class="col-sm-3" id="cardholder_name_required_field" style="display: none">
            <?= $form->field($model, 'cardholder_name_required')->dropDownList([
                0 => Yii::t('app', 'Optional'),
                1 => Yii::t('app', 'Required')
            ]) ?>
        </div>
    </div>
    
    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'hide_label')->widget(SwitchInput::class) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'required')->widget(SwitchInput::class) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <legend><?= Yii::t('app', 'Additional Fields') ?></legend>
        </div>
    </div>

    <?php if (!$model->isNewRecord): ?>
        <?= Html::hiddenInput('email', $model->email, ['id'=>'email']) ?>
        <?= Html::hiddenInput('first_name', $model->first_name, ['id'=>'first_name']) ?>
        <?= Html::hiddenInput('last_name', $model->last_name, ['id'=>'last_name']) ?>
        <?= Html::hiddenInput('company', $model->company, ['id'=>'company']) ?>
        <?= Html::hiddenInput('phone', $model->phone, ['id'=>'phone']) ?>
        <?= Html::hiddenInput('website', $model->website, ['id'=>'website']) ?>
        <?= Html::hiddenInput('address_line1', $model->address_line1, ['id'=>'address_line1']) ?>
        <?= Html::hiddenInput('address_line2', $model->address_line2, ['id'=>'address_line2']) ?>
        <?= Html::hiddenInput('address_city', $model->address_city, ['id'=>'address_city']) ?>
        <?= Html::hiddenInput('address_state', $model->address_state, ['id'=>'address_state']) ?>
        <?= Html::hiddenInput('address_zip', $model->address_zip, ['id'=>'address_zip']) ?>
        <?= Html::hiddenInput('address_country', $model->address_country, ['id'=>'address_country']) ?>
    <?php endif; ?>

    <div class="row">
        <div class="col-sm-2">
            <?= $form->field($model, 'email')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['braintree-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['email'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-2">
            <?= $form->field($model, 'first_name')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['braintree-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['first_name'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-2">
            <?= $form->field($model, 'last_name')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['braintree-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['last_name'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-2">
            <?= $form->field($model, 'company')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['braintree-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['company'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-2">
            <?= $form->field($model, 'phone')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['braintree-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['phone'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-2">
            <?= $form->field($model, 'website')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['braintree-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['website'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>

    </div>

    <div class="row">
        <div class="col-sm-2">
            <?= $form->field($model, 'address_line1')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['braintree-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['address_line1'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-2">
            <?= $form->field($model, 'address_line2')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['braintree-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['address_line2'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-2">
            <?= $form->field($model, 'address_city')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['braintree-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['address_city'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-2">
            <?= $form->field($model, 'address_state')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['braintree-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['address_state'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-2">
            <?= $form->field($model, 'address_zip')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['braintree-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['address_zip'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-2">
            <?= $form->field($model, 'address_country')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['braintree-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['address_country'],
                    'initialize' => !empty($model->form_id),
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
                <span class="help-block">
                    <span class="label label-default"><?= Yii::t('app', 'Note') ?></span>
                    <?= Yii::t(
                        'app',
                        'Although these fields are optional, this information can be used to perform a number of verifications, such as CVC, ZIP, and address verification.'
                    ) ?>
                </span>
        </div>
    </div>

    <div class="form-group" style="margin-top: 20px">
        <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-primary' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>


<?php

$this->registerCss("legend { margin-top: 20px; }");

/**
 * Conditional Logic
 */

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int)!$model->isNewRecord;

$script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#braintree-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['braintree-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

$this->registerJs($script, $this::POS_END, 'braintree-conditions');

/**
 * Field Mapping
 */

if ($model->isNewRecord) {
    $script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="BraintreeItem[description]"]')
                    .attr('name', 'BraintreeItem[' + item + '][description]')
                    .attr('id', 'braintreeitem-' + item + '-description')
                    .removeAttr('disabled')
                    .end()
                .find('[name="BraintreeItem[api_name]"]')
                    .attr('name', 'BraintreeItem[' + item + '][api_name]')
                    .attr('id', 'braintreeitem-' + item + '-api_name')
                    .removeAttr('disabled')
                    .end()
                .find('[name="BraintreeItem[price]"]')
                    .attr('name', 'BraintreeItem[' + item + '][price]')
                    .attr('id', 'braintreeitem-' + item + '-price')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['braintree-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="BraintreeItem[quantity]"]')
                    .attr('name', 'BraintreeItem[' + item + '][quantity]')
                    .attr('id', 'braintreeitem-' + item + '-quantity')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['braintree-form_id'],
                        url: '$url'
                    })
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

} else {


    $script = <<<JS

$(window).on('load', function() {
    $('#braintree-form_id').trigger('depdrop.change');
});

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            // Update the name attributes
            cloned
                .find('[name="BraintreeItem[description]"]')
                    .attr('name', 'BraintreeItem[' + item + '][description]')
                    .attr('id', 'braintreeitem-' + item + '-description')
                    .removeAttr('disabled')
                    .end()
                .find('[name="BraintreeItem[api_name]"]')
                    .attr('name', 'BraintreeItem[' + item + '][api_name]')
                    .attr('id', 'braintreeitem-' + item + '-api_name')
                    .removeAttr('disabled')
                    .end()
                .find('[name="BraintreeItem[price]"]')
                    .attr('name', 'BraintreeItem[' + item + '][price]')
                    .attr('id', 'braintreeitem-' + item + '-price')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['braintree-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-price')
                    .attr('name', 'item-' + item + '-price')
                    .attr('id', 'item-' + item + '-price')
                    .end()
                .find('[name="BraintreeItem[quantity]"]')
                    .attr('name', 'BraintreeItem[' + item + '][quantity]')
                    .attr('id', 'braintreeitem-' + item + '-quantity')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['braintree-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-quantity')
                    .attr('name', 'item-' + item + '-quantity')
                    .attr('id', 'item-' + item + '-quantity')
                    .end()

            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

    $('#braintree-cardholder_name').on('init.bootstrapSwitch', function(event, state) {
        if( this.checked ) {
            $('#cardholder_name_required_field').show();
        } else {
            $('#cardholder_name_required_field').hide();
        }
    });

})

JS;
}

$this->registerJs($script, $this::POS_END);

?>