<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\braintree\services;

use Yii;

class BraintreeService
{
    public $gateway;

    public function __construct($environment, $merchantId, $publicKey, $privateKey)
    {
        spl_autoload_register(function(){
            require_once(Yii::getAlias('@addons/braintree/braintree_sdk/lib/Braintree.php'));
        });

        $this->gateway = new \Braintree_Gateway([
            'environment' => $environment,
            'merchantId' => $merchantId,
            'publicKey' => $publicKey,
            'privateKey' => $privateKey
        ]);
    }

    /**
     * Get Authorization
     *
     * @return string
     */
    public function getAuthorization()
    {
        return $this->gateway->clientToken()->generate();
    }

    /**
     * Post Sale
     *
     * @param $sale
     * @return \Braintree\Result\Error|\Braintree\Result\Successful
     */
    public function sale($sale)
    {
        return $this->gateway->transaction()->sale($sale);
    }

    /**
     * Get Transaction
     *
     * @param $transaction_id
     * @return \Braintree\Transaction
     * @throws \Braintree\Exception\NotFound
     */
    public function getTransaction($transaction_id)
    {
        return $this->gateway->transaction()->find($transaction_id);
    }

    /**
     * Check Transaction Success Status
     *
     * @param $transaction
     * @return bool
     */
    public function isTransactionSuccess($transaction)
    {
        $transactionSuccessStatuses = [
            \Braintree\Transaction::AUTHORIZED,
            \Braintree\Transaction::AUTHORIZING,
            \Braintree\Transaction::SETTLED,
            \Braintree\Transaction::SETTLING,
            \Braintree\Transaction::SETTLEMENT_CONFIRMED,
            \Braintree\Transaction::SETTLEMENT_PENDING,
            \Braintree\Transaction::SUBMITTED_FOR_SETTLEMENT
        ];
        return !empty($transaction->status) && in_array($transaction->status, $transactionSuccessStatuses);
    }

}