<?php

namespace app\modules\addons\modules\braintree\models;

use Yii;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%addon_braintree_payment}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property integer $braintree_id
 * @property integer $submission_id
 * @property string $transaction
 * @property string $data
 * @property integer $created_at
 * @property integer $updated_at
 */
class BraintreePayment extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_braintree_payment}}';
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'braintree_id', 'submission_id', 'created_at', 'updated_at'], 'integer'],
            [['transaction'], 'string', 'max' => 255],
            [['data'], 'string'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'braintree_id' => Yii::t('app', 'Braintree ID'),
            'submission_id' => Yii::t('app', 'Submission ID'),
            'transaction' => Yii::t('app', 'Transaction'),
            'data' => Yii::t('app', 'API Response'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }
}
