<?php

namespace app\modules\addons\modules\braintree\models;

use Yii;

/**
 * This is the model class for table "{{%addon_braintree_item}}".
 *
 * @property integer $id
 * @property integer $braintree_id
 * @property integer $form_id
 * @property string $description
 * @property string $api_name
 * @property string $quantity
 * @property string $price
 */
class BraintreeItem extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_braintree_item}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'braintree_id'], 'integer'],
            [['price'], 'required'],
            [['description'], 'string', 'max' => 127],
            [['api_name', 'quantity', 'price'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'braintree_id' => Yii::t('app', 'Braintree ID'),
            'description' => Yii::t('app', 'Description'),
            'api_name' => Yii::t('app', 'API Name'),
            'quantity' => Yii::t('app', 'Quantity'),
            'price' => Yii::t('app', 'Price'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBraintree()
    {
        return $this->hasOne(Braintree::class,['id'=>'braintree_id']);
    }
}
