<?php

namespace app\modules\addons\modules\braintree\models;

use app\components\behaviors\DateTrait;
use app\models\User;
use Yii;
use app\models\Form;
use app\components\behaviors\RelationTrait;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%addon_braintree}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property integer $status
 * @property string $name
 * @property string $conditions
 * @property integer $event
 * @property string $environment
 * @property string $merchant_id
 * @property string $private_key
 * @property string $public_key
 * @property string $locale
 * @property string $label
 * @property integer $hide_label
 * @property integer $cardholder_name
 * @property integer $cardholder_name_required
 * @property integer $required
 * @property integer $format_input
 * @property string $mask_input
 * @property string $email
 * @property string $first_name
 * @property string $last_name
 * @property string $company
 * @property string $phone
 * @property string $website
 * @property string $address_line1
 * @property string $address_line2
 * @property string $address_city
 * @property string $address_state
 * @property string $address_zip
 * @property string $address_country
 * @property integer $created_by
 * @property integer $updated_by
 * @property integer $created_at
 * @property integer $updated_at
 *
 * @property Form $form
 * @property BraintreeItem[] $items
 * @property User $author
 * @property User $lastEditor
 */
class Braintree extends \yii\db\ActiveRecord
{
    use RelationTrait, DateTrait;

    const ON = 1;
    const OFF = 0;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_braintree}}';
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'form_id', 'environment', 'merchant_id', 'private_key', 'public_key'], 'required'],
            [['form_id', 'status', 'event', 'required', 'cardholder_name', 'hide_label', 'format_input', 'mask_input', 'cardholder_name_required', 'created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
            [['environment', 'merchant_id', 'private_key', 'public_key', 'label', 'email', 'first_name', 'last_name', 'company', 'phone', 'website', 'address_line1', 'address_line2', 'address_city', 'address_state', 'address_zip', 'address_country'], 'string', 'max' => 255],
            [['locale'], 'string', 'max' => 5],
            [['name', 'conditions'], 'string'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'status' => Yii::t('app', 'Status'),
            'name' => Yii::t('app', 'Name'),
            'conditions' => Yii::t('app', 'Conditions'),
            'event' => Yii::t('app', 'Event'),
            'environment' => Yii::t('app', 'Environment'),
            'merchant_id' => Yii::t('app', 'Merchant ID'),
            'private_key' => Yii::t('app', 'Private Key'),
            'public_key' => Yii::t('app', 'Public Key'),
            'locale' => Yii::t('app', 'Locale'),
            'label' => Yii::t('app', 'Label'),
            'hide_label' => Yii::t('app', 'Hide Label'),
            'cardholder_name' => Yii::t('app', 'Cardholder Name'),
            'cardholder_name_required' => Yii::t('app', 'Cardholder Field'),
            'required' => Yii::t('app', 'Required'),
            'format_input' => Yii::t('app', 'Format Input'),
            'mask_input' => Yii::t('app', 'Mask Input'),
            'email' => Yii::t('app', 'Email'),
            'first_name' => Yii::t('app', 'First Name'),
            'last_name' => Yii::t('app', 'Last Name'),
            'company' => Yii::t('app', 'Company'),
            'phone' => Yii::t('app', 'Phone'),
            'website' => Yii::t('app', 'Website'),
            'address_line1' => Yii::t('app', 'Address Line1'),
            'address_line2' => Yii::t('app', 'Address Line2'),
            'address_city' => Yii::t('app', 'Address City'),
            'address_state' => Yii::t('app', 'Address State'),
            'address_zip' => Yii::t('app', 'Address Zip'),
            'address_country' => Yii::t('app', 'Address Country'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getItems()
    {
        return $this->hasMany(BraintreeItem::class, ['braintree_id' => 'id']);
    }

    public function setItems($value)
    {
        $this->loadRelated('items', $value);
    }

    /**
     * @inheritdoc
     */
    public function beforeDelete()
    {
        if (parent::beforeDelete()) {
            BraintreeItem::deleteAll(["braintree_id" => $this->id]);
            BraintreePayment::deleteAll(["braintree_id" => $this->id]);
            return true;
        } else {
            return false;
        }
    }

    /**
     * @param $item
     * @return bool
     */
    public function beforeRSave($item)
    {
        $isValid = true;
        if ($item instanceof BraintreeItem) {
            $isValid = !empty($item->price);
        }
        return $isValid;
    }

}
