<?php

use yii\db\Migration;

/**
 * Class m200626_221955_update_to_1_2
 */
class m200626_221955_update_to_1_2 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Add Conditional logic fields
        $this->addColumn('{{%addon_braintree}}', 'name', $this->text()->notNull()->after('status'));
        $this->addColumn('{{%addon_braintree}}', 'event', $this->integer()->notNull()->defaultValue(1)->after('name'));
        $this->addColumn('{{%addon_braintree}}', 'conditions', $this->text()->after('event'));

        // Add foreign column to fields
        $this->addColumn('{{%addon_braintree_item}}', 'braintree_id', $this->integer(11)->notNull()->after('id'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_braintree_item}}', 'braintree_id');

        $this->dropColumn('{{%addon_braintree}}', 'event');
        $this->dropColumn('{{%addon_braintree}}', 'conditions');
        $this->dropColumn('{{%addon_braintree}}', 'name');
    }

}
