<?php

use yii\db\Migration;

/**
 * Class m190629_110655_init_addon_braintree
 */
class m190629_110655_init_addon_braintree extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_braintree}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(0),

            // Braintree Auth
            'environment' => $this->text()->notNull(),
            'merchant_id' => $this->text()->notNull(),
            'public_key' => $this->text()->notNull(),
            'private_key' => $this->text()->notNull(),

            // Credit Card Field Settings
            'required' => $this->boolean()->notNull()->defaultValue(0),
            'locale' => $this->string(5)->notNull()->defaultValue('en_US'), // 5-letter locale code
            'label' => $this->text(),
            'hide_label' => $this->boolean()->notNull()->defaultValue(0),
            'cardholder_name' => $this->boolean()->notNull()->defaultValue(0),
            'cardholder_name_required' => $this->boolean()->notNull()->defaultValue(0),

            'format_input' => $this->boolean()->notNull()->defaultValue(1),
            'mask_input' => $this->boolean()->notNull()->defaultValue(1),
            'opt_in' => $this->boolean()->defaultValue(0),
            'opt_in_field' => $this->string(191),

            // Additional Fields
            'email' => $this->text(), // The email address where the receipt was sent
            'first_name' => $this->text(),
            'last_name' => $this->text(),
            'company' => $this->text(),
            'phone' => $this->text(),
            'website' => $this->text(),
            'address_line1' => $this->text(),
            'address_line2' => $this->text(),
            'address_city' => $this->text(),
            'address_state' => $this->text(),
            'address_zip' => $this->text(),
            'address_country' => $this->text(),

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),

        ], $tableOptions);

        $this->createTable('{{%addon_braintree_item}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),

            'description' => $this->text(), // Item name
            'api_name' => $this->text(), // Item name
            'quantity' => $this->text(), // Map to Quantity Field
            'price' => $this->text(), // Map to Price field

        ], $tableOptions);

        $this->createTable('{{%addon_braintree_payment}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'braintree_id' => $this->integer(11),
            'submission_id' => $this->integer(11),

            'transaction' => $this->text(),
            'data' => $this->text()->notNull(), // Save response as JSON

            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%addon_braintree_payment}}');
        $this->dropTable('{{%addon_braintree_item}}');
        $this->dropTable('{{%addon_braintree}}');
    }
}
