<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\aweber\models;

use app\components\behaviors\DateTrait;
use Yii;
use app\models\Form;
use app\models\User;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;
use app\components\behaviors\RelationTrait;

/**
 * This is the model class for table "{{%addon_aweber}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property integer $status
 * @property string $authorization_code
 * @property string $oauth
 * @property string $name
 * @property string $conditions
 * @property integer $event
 * @property string $list_id
 * @property string $list_name
 * @property string $subscriber_email
 * @property string $subscriber_name
 * @property string $subscriber_tags
 * @property string $subscriber_ad_tracking
 * @property string $subscriber_misc_notes
 * @property integer $subscriber_last_followup_message_number_sent
 * @property integer $subscriber_ip_address
 * @property integer $created_by
 * @property integer $updated_by
 * @property integer $created_at
 * @property integer $updated_at
 *
 * @property Form $form
 * @property AweberField[] $items
 * @property User $author
 * @property User $lastEditor
 */
class Aweber extends \yii\db\ActiveRecord
{
    use RelationTrait, DateTrait;

    const ON = 1;
    const OFF = 0;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_aweber}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'authorization_code', 'nickname', 'name', 'list_id', 'list_name', 'subscriber_email'], 'required'],
            [['form_id', 'status', 'event', 'subscriber_last_followup_message_number_sent', 'subscriber_ip_address', 'created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
            [['authorization_code', 'nickname', 'list_id', 'list_name', 'subscriber_email', 'subscriber_name', 'subscriber_tags'], 'string', 'max' => 255],
            [['subscriber_ad_tracking'], 'string', 'max' => 20],
            [['subscriber_misc_notes'], 'string', 'max' => 60],
            [['oauth', 'conditions'], 'string']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'status' => Yii::t('app', 'Status'),
            'authorization_code' => Yii::t('app', 'AWeber Authorization Code'),
            'oauth' => Yii::t('app', 'Oauth'),
            'nickname' => Yii::t('app', 'AWeber Account Nickname'),
            'name' => Yii::t('app', 'Name'),
            'conditions' => Yii::t('app', 'Conditions'),
            'event' => Yii::t('app', 'Event'),
            'list_id' => Yii::t('app', 'List ID'),
            'list_name' => Yii::t('app', 'List Name'),
            'subscriber_email' => Yii::t('app', 'Subscriber Email Address'),
            'subscriber_name' => Yii::t('app', 'Subscriber Name'),
            'subscriber_tags' => Yii::t('app', 'Subscriber Tags'),
            'subscriber_ad_tracking' => Yii::t('app', 'Customer Ad Tracking Field'),
            'subscriber_misc_notes' => Yii::t('app', 'Miscellaneous notes'),
            'subscriber_last_followup_message_number_sent' => Yii::t('app', 'Last Follow Up Message Number Sent'),
            'subscriber_ip_address' => Yii::t('app', 'Subscriber\'s IP Address'),
            'created_by' => Yii::t('app', 'Created by'),
            'updated_by' => Yii::t('app', 'Updated by'),
            'created_at' => Yii::t('app', 'Created at'),
            'updated_at' => Yii::t('app', 'Updated at'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getItems()
    {
        return $this->hasMany(AweberField::class, ['aweber_id' => 'id']);
    }

    public function setItems($value)
    {
        $this->loadRelated('items', $value);
    }

    /**
     * @inheritdoc
     */
    public function beforeDelete()
    {
        if (parent::beforeDelete()) {
            AweberField::deleteAll(["aweber_id" => $this->id]);
            return true;
        } else {
            return false;
        }
    }
}