<?php

use yii\db\Migration;

/**
 * Class m200926_015443_update_to_1_5
 */
class m200926_015443_update_to_1_5 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Authorization
        $this->addColumn('{{%addon_aweber}}', 'authorization_code', $this->text()->after('status'));
        $this->addColumn('{{%addon_aweber}}', 'oauth', $this->text()->after('authorization_code'));
        $this->addColumn('{{%addon_aweber}}', 'nickname', $this->string(191)->after('oauth'));

        $this->dropColumn('{{%addon_aweber}}', 'consumer_key');
        $this->dropColumn('{{%addon_aweber}}', 'consumer_secret');
        $this->dropColumn('{{%addon_aweber}}', 'access_token');
        $this->dropColumn('{{%addon_aweber}}', 'access_secret');

    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_aweber}}', 'authorization_code');
        $this->dropColumn('{{%addon_aweber}}', 'oauth');
        $this->dropColumn('{{%addon_aweber}}', 'nickname');

        $this->addColumn('{{%addon_aweber}}', 'consumer_key', $this->string(255)->notNull());
        $this->addColumn('{{%addon_aweber}}', 'consumer_secret', $this->string(255)->notNull());
        $this->addColumn('{{%addon_aweber}}', 'access_token', $this->string(255)->notNull());
        $this->addColumn('{{%addon_aweber}}', 'access_secret', $this->string(255)->notNull());
    }

}
