<?php

use yii\db\Migration;

/**
 * Class m200625_232516_update_to_1_4
 */
class m200625_232516_update_to_1_4 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Add Conditional logic fields
        $this->addColumn('{{%addon_aweber}}', 'name', $this->string(191)->notNull()->after('status'));
        $this->addColumn('{{%addon_aweber}}', 'event', $this->integer()->notNull()->defaultValue(1)->after('name'));
        $this->addColumn('{{%addon_aweber}}', 'conditions', $this->text()->after('event'));

        // Add foreign column to fields
        $this->addColumn('{{%addon_aweber_field}}', 'aweber_id', $this->integer(11)->notNull()->after('id'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_aweber_field}}', 'aweber_id');

        $this->dropColumn('{{%addon_aweber}}', 'event');
        $this->dropColumn('{{%addon_aweber}}', 'conditions');
        $this->dropColumn('{{%addon_aweber}}', 'name');
    }

}
