<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

use yii\db\Schema;
use yii\db\Migration;

class m150420_183551_init_addon_aweber extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_aweber}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(1),
            // Authorization
            'consumer_key' => $this->text()->notNull(),
            'consumer_secret' => $this->text()->notNull(),
            'access_token' => $this->text()->notNull(),
            'access_secret' => $this->text()->notNull(),
            // Required Information
            'list_id' => $this->text()->notNull(),
            'list_name' => $this->text()->notNull(),
            // Subscriber Fields
            'subscriber_email' => $this->string(191)->notNull(),
            'subscriber_name' => $this->string(191),
            // Settings
            'subscriber_tags' => $this->text(),
            'subscriber_ad_tracking' => $this->string(20),
            'subscriber_misc_notes' => $this->string(60),
            'subscriber_last_followup_message_number_sent' => $this->integer(4),
            'subscriber_ip_address' => $this->boolean()->defaultValue(1),
            'opt_in' => $this->boolean()->defaultValue(0),
            'opt_in_field' => $this->string(191),
            'created_by' => Schema::TYPE_INTEGER . '(11) NOT NULL',
            'updated_by' => Schema::TYPE_INTEGER . '(11) NOT NULL',
            'created_at' => Schema::TYPE_INTEGER,
            'updated_at' => Schema::TYPE_INTEGER,
        ], $tableOptions);

        $this->createTable('{{%addon_aweber_field}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'form_field' => $this->string(191), // Easy Forms Form Field
            'list_field' => $this->string(191), // Aweber Subscriber List Field
        ], $tableOptions);
    }

    public function safeDown()
    {
        $this->dropTable('{{%addon_aweber_field}}');
        $this->dropTable('{{%addon_aweber}}');
    }
}
