<?php

use app\components\widgets\ConditionsBuilder;
use app\helpers\EventHelper;
use yii\helpers\Html;
use yii\helpers\Url;
use kartik\form\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;
use app\modules\addons\modules\adyen\helpers\Currency;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\adyen\models\Adyen */
/* @var $itemModel app\modules\addons\modules\adyen\models\AdyenItem */
/* @var $form yii\widgets\ActiveForm */
/* @var $forms array [id => name] of Form models */

$url = Url::to(['/addons/adyen/admin/fields']);

?>

<div class="adyen-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'name')->textInput([
                'placeholder' => Yii::t('app', "Enter a configuration name..."),
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'form_id')->widget(Select2::class, [
                'data' => $forms,
                'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(Yii::t('app', 'Form')); ?>
        </div>
        <div class="col-sm-3">
            <?php if ($model->isNewRecord) { $model->status = true; } ?>
            <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
        </div>
        <div class="col-sm-3">
            <?php if ($model->isNewRecord) { $model->live = false; } ?>
            <?= $form->field($model, 'live')->widget(SwitchInput::class) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'api_key')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'origin_key')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'loading_context')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'live_url_prefix')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'merchant_account')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-sm-6">
            <?= $form->field($model, 'event')->widget(Select2::class, [
                'data' => EventHelper::supportedFormEventsInPostRequest(),
            ]); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= ConditionsBuilder::widget([
                'label' => Yii::t('app', 'Conditions'),
            ]) ?>
            <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <legend><?= Yii::t('app', 'Items') ?></legend>
        </div>
    </div>
    
    <?php if ($model->isNewRecord): ?>

        <fieldset class="item">
            <div class="row">
                <div class="col-sm-6">
                    <?= $form->field($itemModel, '[0]description')->textInput([
                        'maxlength' => true,
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, '[0]price')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['adyen-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => Url::to(['/addons/adyen/admin/fields']),
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, '[0]quantity')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['adyen-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => Url::to(['/addons/adyen/admin/fields']),
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-default btn-icon btn-add">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                </div>
            </div>
        </fieldset>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-6">
                    <?= $form->field($itemModel, 'description')->textInput([
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, 'price')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['adyen-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'quantity')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['adyen-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-default btn-icon btn-remove">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </div>
        </fieldset>

    <?php else: ?>

        <?php foreach($model->items as $i => $item): ?>
            <fieldset class="item">
                <div class="row">
                    <div class="col-sm-6">
                        <?= $form->field($item, '['.$i.']description')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('item-'.$i.'-price',
                            $item->price, ['id'=>'item-'.$i.'-price']) ?>
                        <?= $form->field($item, '['.$i.']price')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['adyen-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['item-'.$i.'-price'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('item-'.$i.'-quantity',
                            $item->quantity, ['id'=>'item-'.$i.'-quantity']) ?>
                        <?= $form->field($item, '['.$i.']quantity')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['adyen-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['item-'.$i.'-quantity'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 28px;">
                            <button type="button" class="btn btn-default btn-icon btn-remove">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </fieldset>
        <?php endforeach; ?>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-6">
                    <?= $form->field($itemModel, 'description')->textInput([
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= Html::hiddenInput('item-price', '', ['id'=>'item-price']) ?>
                    <?= $form->field($itemModel, 'price')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['adyen-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                            'params'=>['item-price'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= Html::hiddenInput('item-quantity', '', ['id'=>'item-quantity']) ?>
                    <?= $form->field($itemModel, 'quantity')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['adyen-form_id'],
                            'initialize' => true,
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                            'params'=>['item-quantity'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-default btn-icon btn-remove">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </div>
        </fieldset>
    
    <?php endif; ?>

    <div class="alert alert-default mt-3" style="background-color: #e9ecef;">
        <p><strong><?= Yii::t('app', 'Note') ?></strong>
            <?= Yii::t('app', 'Each item specify information about a product or service.') ?>
            <?= Yii::t('app', 'Price (required) and Quantity (optional) will be multiplied in order to get the item total value.') ?>
        </p>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <legend><?= Yii::t('app', 'Credit Card Field Settings') ?></legend>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <?php if ($model->isNewRecord) { $model->label = Yii::t('app', 'Credit Card'); } ?>
            <?= $form->field($model, 'label')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'locale')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'currency')->dropDownList(Currency::all()) ?>
        </div>
        <div class="col-sm-3">
            <?php if ($model->isNewRecord) { $model->dom_element = 'card'; } ?>
            <?= $form->field($model, 'dom_element')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'hide_label')->widget(SwitchInput::class) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'required')->widget(SwitchInput::class) ?>
        </div>
        <div class="col-sm-3">
            <?php if ($model->isNewRecord) { $model->store_details = false; } ?>
            <?= $form->field($model, 'store_details')->widget(SwitchInput::class) ?>
        </div>
        <div class="col-sm-3">
            <?php if ($model->isNewRecord) { $model->holder_name = false; } ?>
            <?= $form->field($model, 'holder_name')->widget(SwitchInput::class) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?php if ($model->isNewRecord) { $model->styles = "{
  base: {
    color: 'black',
    fontSize: '16px',
    fontSmoothing: 'antialiased',
    fontFamily: 'Helvetica'
  },
  error: {
    color: 'red'
  },
  placeholder: {
    color: '#d8d8d8'
  },
  validated: {
    color: 'green'
  }
}"; } ?>
            <?= $form->field($model, 'styles')->textarea(['rows' => '3'])
                ->hint(Yii::t('app', 'Customize the Credit Card Field appearance using CSS properties in JSON format.')) ?>
        </div>
        <div class="col-sm-6">
            <?php if ($model->isNewRecord) { $model->placeholders = "{
  encryptedCardNumber : '4212 3456 7891 0006',
  encryptedExpiryDate : '03/30',
  encryptedSecurityCode : '737'
}"; } ?>
            <?= $form->field($model, 'placeholders')->textarea(['rows' => '3'])
                ->hint(Yii::t('app', 'Specify the sample values you want to appear for card detail input fields in JSON format.')) ?>
        </div>
    </div>

    <div class="form-group" style="margin-top: 20px">
        <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-primary' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>


<?php

$this->registerCss("legend { margin-top: 20px; }");

/**
 * Conditional Logic
 */

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int)!$model->isNewRecord;

$script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#adyen-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['adyen-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

$this->registerJs($script, $this::POS_END, 'adyen');

/**
 * Field Mapping
 */

if ($model->isNewRecord) {
    $script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="AdyenItem[description]"]')
                    .attr('name', 'AdyenItem[' + item + '][description]')
                    .attr('id', 'adyenitem-' + item + '-description')
                    .removeAttr('disabled')
                    .end()
                .find('[name="AdyenItem[price]"]')
                    .attr('name', 'AdyenItem[' + item + '][price]')
                    .attr('id', 'adyenitem-' + item + '-price')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['adyen-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="AdyenItem[quantity]"]')
                    .attr('name', 'AdyenItem[' + item + '][quantity]')
                    .attr('id', 'adyenitem-' + item + '-quantity')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['adyen-form_id'],
                        url: '$url'
                    })
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

} else {


    $script = <<<JS

$(window).on('load', function() {
    $('#adyen-form_id').trigger('depdrop.change');
});

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fas-minus').removeClass('fas-minus').addClass('fas-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            // Update the name attributes
            cloned
                .find('[name="AdyenItem[description]"]')
                    .attr('name', 'AdyenItem[' + item + '][description]')
                    .attr('id', 'adyenitem-' + item + '-description')
                    .removeAttr('disabled')
                    .end()
                .find('[name="AdyenItem[price]"]')
                    .attr('name', 'AdyenItem[' + item + '][price]')
                    .attr('id', 'adyenitem-' + item + '-price')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['adyen-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-price')
                    .attr('name', 'item-' + item + '-price')
                    .attr('id', 'item-' + item + '-price')
                    .end()
                .find('[name="AdyenItem[quantity]"]')
                    .attr('name', 'AdyenItem[' + item + '][quantity]')
                    .attr('id', 'adyenitem-' + item + '-quantity')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['adyen-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-quantity')
                    .attr('name', 'item-' + item + '-quantity')
                    .attr('id', 'item-' + item + '-quantity')
                    .end()

            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
}

$this->registerJs($script, $this::POS_END);

?>