<?php

namespace app\modules\addons\modules\adyen\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;

/**
 * AdyenPaymentSearch represents the model behind the search form about `app\modules\addons\modules\adyen\models\AdyenPayment`.
 */
class AdyenPaymentSearch extends AdyenPayment
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'form_id', 'adyen_id', 'submission_id', 'created_at', 'updated_at'], 'integer'],
            [['transaction', 'result_code', 'response', 'amount', 'currency'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = AdyenPayment::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => Yii::$app->params['GridView.pagination.pageSize'],
            ],
            'sort' => [
                'defaultOrder' => [
                    'updated_at' => SORT_DESC,
                ]
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // Add Scope
        if (isset($params['id'])) {
            $this->adyen_id = $params['id'];
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'form_id' => $this->form_id,
            'submission_id' => $this->submission_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ]);

        $query->andFilterWhere(['like', 'response', $this->response])
            ->andFilterWhere(['like', 'transaction', $this->transaction])
            ->andFilterWhere(['like', 'result_code', $this->result_code])
            ->andFilterWhere(['like', 'amount', $this->amount])
            ->andFilterWhere(['like', 'currency', $this->currency]);

        return $dataProvider;
    }
}