<?php

namespace app\modules\addons\modules\adyen\models;

use Yii;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%addon_adyen_payment}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property integer $adyen_id
 * @property integer $submission_id
 * @property string $transaction
 * @property string $result_code
 * @property string $amount
 * @property string $currency
 * @property string $response
 * @property integer $created_at
 * @property integer $updated_at
 */
class AdyenPayment extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_adyen_payment}}';
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'adyen_id', 'submission_id', 'created_at', 'updated_at'], 'integer'],
            [['transaction', 'result_code', 'amount'], 'string', 'max' => 255],
            [['currency'], 'string', 'max' => 3],
            [['response'], 'string'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'adyen_id' => Yii::t('app', 'Adyen ID'),
            'submission_id' => Yii::t('app', 'Submission ID'),
            'transaction' => Yii::t('app', 'Transaction'),
            'result_code' => Yii::t('app', 'Result Code'),
            'amount' => Yii::t('app', 'Amount'),
            'currency' => Yii::t('app', 'Currency'),
            'response' => Yii::t('app', 'Response'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }
}
