<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 */
namespace app\modules\addons\modules\adyen\models;

use Yii;

/**
 * This is the model class for table "{{%addon_adyen_item}}".
 *
 * @property integer $id
 * @property integer $adyen_id
 * @property integer $form_id
 * @property string $description
 * @property string $quantity
 * @property string $price
 * @property Adyen $adyen
 */
class AdyenItem extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_adyen_item}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['adyen_id', 'form_id'], 'integer'],
            [['description'], 'string', 'max' => 127],
            [['quantity', 'price'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'adyen_id' => Yii::t('app', 'Adyen ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'description' => Yii::t('app', 'Description'),
            'quantity' => Yii::t('app', 'Quantity'),
            'price' => Yii::t('app', 'Price'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAdyen()
    {
        return $this->hasOne(Adyen::class,['id'=>'adyen_id']);
    }

}