<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 */
namespace app\modules\addons\modules\adyen\models;

use app\components\behaviors\DateTrait;
use app\models\User;
use Yii;
use app\models\Form;
use app\components\behaviors\RelationTrait;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%addon_adyen}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property integer $status
 * @property string $name
 * @property string $conditions
 * @property integer $event
 * @property integer $live
 * @property integer $required
 * @property string  $live_url_prefix
 * @property string  $merchant_account
 * @property string  $api_key
 * @property string  $origin_key
 * @property string  $loading_context
 * @property string  $label
 * @property integer $hide_label
 * @property string  $description
 * @property string  $currency
 * @property string  $locale
 * @property string  $dom_element
 * @property string  $store_details
 * @property string  $holder_name
 * @property string  $styles
 * @property string  $placeholders
 * @property integer $created_by
 * @property integer $updated_by
 * @property integer $created_at
 * @property integer $updated_at
 *
 * @property Form    $form
 * @property AdyenItem[] $items
 * @property User $author
 * @property User $lastEditor
 */
class Adyen extends \yii\db\ActiveRecord
{
    use RelationTrait, DateTrait;

    const ON = 1;
    const OFF = 0;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_adyen}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'merchant_account', 'api_key', 'origin_key', 'name', 'loading_context', 'dom_element'], 'required'],
            [['form_id', 'status', 'event', 'live', 'required', 'hide_label', 'store_details','holder_name'], 'integer'],
            [[ 'name', 'conditions', 'styles', 'placeholders'], 'string'],
            [['live_url_prefix', 'merchant_account', 'api_key', 'origin_key', 'loading_context', 'dom_element', 'label', 'dom_element'], 'string', 'max' => 255],
            [['currency'], 'string', 'max' => 3],
            [['locale'], 'string', 'max' => 5],
            [['live_url_prefix'], 'required', 'when' => function ($model) {
                return $model->live === 1;
            }, 'whenClient' => "function (attribute, value) {
                return $(\"input[name='Adyen[live]']:checked\").val() == '1';
            }"],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form'),
            'status' => Yii::t('app', 'Status'),
            'live' => Yii::t('app', 'Live'),
            'live_url_prefix' => Yii::t('app', 'Live Url Prefix'),
            'merchant_account' => Yii::t('app', 'Merchant Account'),
            'api_key' => Yii::t('app', 'Api Key'),
            'origin_key' => Yii::t('app', 'Origin Key'),
            'name' => Yii::t('app', 'Name'),
            'conditions' => Yii::t('app', 'Conditions'),
            'event' => Yii::t('app', 'Event'),
            'loading_context' => Yii::t('app', 'Loading Context'),
            'label' => Yii::t('app', 'Label'),
            'hide_label' => Yii::t('app', 'Hide Label'),
            'required' => Yii::t('app', 'Required'),
            'description' => Yii::t('app', 'Description'),
            'currency' => Yii::t('app', 'Currency'),
            'locale' => Yii::t('app', 'Locale'),
            'dom_element' => Yii::t('app', 'Dom Element'),
            'store_details' => Yii::t('app', 'Store Details'),
            'holder_name' => Yii::t('app', 'Holder Name'),
            'styles' => Yii::t('app', 'Styles'),
            'placeholders' => Yii::t('app', 'Placeholders'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getItems()
    {
        return $this->hasMany(AdyenItem::class, ['adyen_id' => 'id']);
    }

    public function setItems($value)
    {
        $this->loadRelated('items', $value);
    }

    /**
     * @inheritdoc
     */
    public function beforeDelete()
    {
        if (parent::beforeDelete()) {
            AdyenItem::deleteAll(["adyen_id" => $this->id]);
            AdyenPayment::deleteAll(["adyen_id" => $this->id]);
            return true;
        } else {
            return false;
        }
    }
}